(ns ksql.ingestion-api
  (:require [clojure.tools.logging :as log]
            [ksql.gen :as gen]
            [ksql.metadata-api :as md]
            [ksql.gen-connector :as conn]
            [ksqldb.client :as client]
            [cheshire.core :as json]
            [ksql.gen.protocol :as p]
           #_[ksql.gen.protocol :as p]
            ;[ksql.ksqldb-api :as kapi]
           #_[cheshire.core :as json]
           [ksql.gen-api :as gapi]
            [ksql.ksqldb-api :as kapi]
           [ksql.core :as core]
            ))


(defn invoke-dataflow
  [op-name request]
  (p/invoke-dataflow-impl op-name (core/get-context) request))


#_(defn reset-schema-m []
  (update (core/get-context) :metadata-repo (fn [v-atom]
                                               (reset! v-atom []))))


(defn export-ksql-to-file
  "Export generated KSQL statement to file
  file-name: Saving file name
  mapping: Mapping file or mapping as data
  "
  [file-name mapping]
  (let [o (gapi/gen-ksql-by-mapping mapping)
        o (clojure.string/join "\n" o)]
    (spit file-name o :append true)))


(defn import-ksql-from-file
  "Import KSQl to KSQl server after apply delta "
  [file-name]
  (->> (clojure.string/split (slurp file-name) #"\n")
       (remove (fn [v] (clojure.string/blank? v)))
       (vec)
       (kapi/ksql-batch (core/get-context))))


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defn get-mapping-store [context]
  (get context :metadata-repo))


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


(defn map-ksql [schema-coll]
  (->> schema-coll
       (into [] (comp (map :statement) cat))))








(defmethod p/invoke-dataflow-impl
  :default
  [op-name context {:keys [op]}]
  (let [api-list (-> (into #{} (keys (methods p/invoke-dataflow-impl)))
                     (disj :default))]
    (throw (ex-info (str "api name " op " not found, available api \n" (clojure.string/join "\n" api-list)) {}))))





(defmethod p/invoke-dataflow-impl "create-dataflow"
  [op-name context mapping]
  (let [store (get-mapping-store context)
        schema-m-coll (p/get-all-metadata store)

        new-schema-m-coll (gen/do-process context schema-m-coll mapping)
        delta-schema-m-coll (->> (split-at (count schema-m-coll) new-schema-m-coll)
                                 (second)
                                 (into []))
        delta-schema-m-coll (mapv (fn [schema-m t]
                                    (if (= (vector (get schema-m :sink-name))
                                           (get schema-m :source-name))
                                      schema-m
                                      (assoc-in schema-m [:writeQueries] [{:id t}]))
                                    ) delta-schema-m-coll (range))
        ksql-coll (map-ksql delta-schema-m-coll)]
    (try
      (kapi/ksql-batch context ksql-coll)
      (p/push-metadata store delta-schema-m-coll)
      ksql-coll
      (catch Exception e
        (->> (ex-data e)
             (:body)
             (json/parse-string)
             )
        )
      )
    ))



(defmethod p/invoke-dataflow-impl "show-dataflow"
  [op-name context mapping]
  (let [store (get-mapping-store context)
        schema-m-coll (p/get-all-metadata store)

        new-schema-m-coll (gen/do-process context schema-m-coll mapping)]
    (->> (split-at (count schema-m-coll) new-schema-m-coll)
         (second)
         (into [])
         (map-ksql))))


(defmethod p/invoke-dataflow-impl "delete-dataflow"
  [op-name context _]
  (let [store (get-mapping-store context)
        schema-m-coll (p/peek-metadata store)
        stream-name (into [] (comp (map :sink-name)
                                   ) schema-m-coll)]

    ;(p/log-v stream-name )

    (kapi/remove-ksql-statement context stream-name false)
    (p/pull-metadata store)
    stream-name))


(defmethod p/invoke-dataflow-impl "delete-dataflow-with-data"
  [op-name context _]
  (let [store (get-mapping-store context)
        schema-m-coll (p/peek-metadata store)
        stream-name (into [] (comp (map :sink-name)
                                   ) schema-m-coll)]
    (kapi/remove-ksql-statement context stream-name true)
    (p/pull-metadata store)
    stream-name))


#_(defmethod p/invoke-dataflow "delete-dataflow"
    [op-name context mapping]
    (let [schema-m-coll (get-mapping-schema-repo context)
          ;   _ (println schema-m-coll)
          m (gen/gen-drop-ksql context schema-m-coll mapping)
          ;  _ (println "--delete data flow " m )
          ksql (get m :ksql)]
      (push-ksql-statement context ksql)

      ksql
      ))



#_(defmethod p/invoke-dataflow "delete-dataflow-with-data"
    [op-name context mapping]
    (let [schema-m-coll (get-mapping-schema-repo context)
          m (gen/gen-drop-ksql context schema-m-coll mapping true)
          ksql-coll (get m :ksql)
          topic-coll (get m :topic)
          schema-name-coll (get m :schema)]
      (client/ksql-batch context ksql-coll)
      (client/invoke context {:op "broker-delete-topics" :request topic-coll})

      (doseq [schema-name schema-name-coll]
        (client/invoke context {:op "delete-schema" :request schema-name}))))



(defmethod p/invoke-dataflow-impl "update-dataflow"
  [op-name context mapping]
  (do (p/invoke-dataflow-impl "delete-dataflow" context mapping)
      (p/invoke-dataflow-impl "create-dataflow" context mapping)))


(defn find-delta-connection [context connector-coll]
  (let [remote-conn-set (into #{} (map :name) (client/invoke context "show-connectors-status"))]
    (remove (fn [v] (contains? remote-conn-set (:name v))) connector-coll)))


(defmethod p/invoke-dataflow-impl "create-source-connector"
  [op-name context connector-mapping]
  ;(create-dataflow-by-source-mapping base-dir connector-mapping)
  (let [conn-coll (->> connector-mapping
                       (conn/gen-source-connector-config context)
                       (find-delta-connection context))]
    ;(println "--" conn-coll)
    (when-not (empty? conn-coll)
      (log/info "Creating new connection")
      (client/invoke context "create-connector-batch" conn-coll )
      #_(invoke-kafka "create-connector-batch" conn-coll))))


(defmethod p/invoke-dataflow-impl "delete-source-connector"
  [op-name context connector-mapping]
  (let [connector-name-list (conn/get-source-connector-names context connector-mapping)]

    (doseq [connector-name connector-name-list]
      (client/invoke context "delete-connector" connector-name)
      #_(invoke-kafka "delete-connector" connector-name))))

;(defn p)


(defmethod p/invoke-dataflow-impl "pause-source-connector"
  [op-name context connector-mapping]
  (let [
        connector-name-list (conn/get-source-connector-names context connector-mapping)]
    (doseq [connector-name connector-name-list]
      (client/invoke context "pause-connector" connector-name))))


(defmethod p/invoke-dataflow-impl "resume-source-connector"
  [op-name context connector-mapping]
  (let [connector-name-list (conn/get-source-connector-names context connector-mapping)]
    (doseq [connector-name connector-name-list]
      (client/invoke context "resume-connector" connector-name))))


;(def create-source-connector gen/create-source-connector)
;(def delete-source-connector gen/delete-source-connector)
#_(defn create-sink-connector
    ([sink-mapping] (create-sink-connector "" sink-mapping))
    ([base-dir sink-mapping]
     (u/create-sink-connector context base-dir sink-mapping)))


(defmethod p/invoke-dataflow-impl "create-sink-connector"
  [op-name context sink-connector-mapping]
  (let [
        conn-coll (conn/gen-sink-connector-config context sink-connector-mapping)

        ; req-coll (into others w)
        ;   conn-coll (crate-sink-connector-req connector-schema)
        ;   _ (  conn-coll)
        conn-coll (find-delta-connection context conn-coll)]

    ;(  w)
    ;(  create-sql-for-sink)
    ;(  sql-coll)

    #_(when-not (empty? ksql-coll)
        (let [ksql-coll (get-delta-ksql-statement context ksql-coll)]
          (client/ksql-batch context ksql-coll)))
    (when-not (empty? conn-coll)
      (log/info "Creating new connection")
      ;(client/invoke context {:op "create-connector-batch" :request conn-coll})
      (client/invoke context "create-connector-batch" conn-coll))))



(defmethod p/invoke-dataflow-impl "req-handler"
  [op-name context mapping]
  #_(let [

          schema-m-coll (get-mapping-schema-repo context)
          new-schema-m-coll (gen/do-process context schema-m-coll mapping)
          delta-schema-m-coll (->> (split-at (count schema-m-coll) new-schema-m-coll)
                                   (second)
                                   (into []))
          ksql-coll (map-ksql delta-schema-m-coll)]
      (push-ksql-statement context ksql-coll)
      (update-mapping-schema-repo context delta-schema-m-coll)
      ksql-coll))



