(ns ksql.gen.macro.expand-flow-impl
  (:require [ksql.gen.protocol :as p]
            [ksql.gen.util :as u])
  )



(defmulti expand-flow-internal (fn [_ mapping-fields] (first (get (first mapping-fields) :transfer_fn))))


(defmethod expand-flow-internal :default
  [_ mapping]
  ;(println "--" mapping)
  [mapping]
  )




;csv-file-list (get-all-files csv-folder-name "glob:*.{csv}")


(defmethod expand-flow-internal "map_before_v1"
  [md-repo mapping]
  ;(  mapping)
  (let [mapping (first mapping)
        n (get mapping :name)
        ; n (get mapping :name)
        [_ source-name key-name] (get mapping :transfer_fn)
        schema (p/get-source-schema md-repo source-name)
        fields (get schema :fields)
        stage-name (str source-name "_stage")
        stage-name-tab (str stage-name "_tab")
        ;statge-enrich (str source-name "_stage")

        stage-mapping-fields (into [] (map (fn [field]
                                             (-> field
                                                 (assoc :name stage-name)
                                                 (assoc :field_name (get field :name))
                                                 (dissoc :schema)
                                                 (assoc :transfer_fn ["as" (str source-name "/" (get field :name))])
                                                 )
                                             )) fields)

        stage-mapping-fields (conj stage-mapping-fields {:name        stage-name
                                                         :transfer_fn ["key" key-name]})

        cust_stage_tab-fields (into [] (map (fn [field]
                                              (-> field
                                                  (assoc :name stage-name-tab)
                                                  (assoc :field_name (get field :name))
                                                  (dissoc :schema)
                                                  (assoc :transfer_fn ["as" (str stage-name "/" (get field :name))])
                                                  )
                                              )) fields)

        cust_stage_tab-fields (into cust_stage_tab-fields [{:name        stage-name-tab
                                                            :transfer_fn ["key" key-name]}
                                                           {:name        stage-name-tab
                                                            :transfer_fn ["type" "table"]}])
        enrich-fields (into [] (map (fn [field]
                                      (-> field
                                          (assoc :name n)
                                          (assoc :field_name (get field :name))
                                          (dissoc :schema)
                                          (assoc :transfer_fn ["as" (str source-name "/" (get field :name))])
                                          )
                                      )) fields)


        enrich-fields_full (into enrich-fields (map (fn [field]
                                                      (-> field
                                                          (assoc :name n)
                                                          (assoc :field_name (str (get field :name) "_before"))
                                                          (dissoc :schema)
                                                          (assoc :transfer_fn ["as" (str stage-name-tab "/" (get field :name))])
                                                          )
                                                      )) fields)

        enrich-fields_full (into enrich-fields_full [{:name        n
                                                      :transfer_fn ["left_join"
                                                                    (str source-name "/" key-name)
                                                                    (str stage-name-tab "/" key-name)
                                                                    ]}
                                                     ])
        insert-fields (into [] (map (fn [field]
                                      (-> field
                                          (assoc :name stage-name)
                                          (assoc :field_name (get field :name))
                                          (dissoc :schema)
                                          (assoc :transfer_fn ["as" (str n "/" (get field :name))])
                                          )
                                      )) fields)]
    [stage-mapping-fields
     cust_stage_tab-fields
     enrich-fields_full
     insert-fields]))



(defmethod p/expand-flow "map_before_select_new"
  [md-before mapping]

  (let [mapping (first mapping)
        n (get mapping :name)
        ; n (get mapping :name)
        [_ source-name key-name] (get mapping :transfer_fn)
        schema (p/get-source-schema md-before source-name)
        fields (get schema :fields)
        ; _ (println source-name "--" fields "--" mapping)
        select-fields (into [] (comp (map (fn [f] (get f :name)))
                                     (remove (fn [f]

                                               (clojure.string/ends-with? f "_before")))
                                     (map (fn [f]
                                            [n f (str source-name "/" f)]
                                            )

                                          )
                                     cat

                                     ) fields)
        select-fields (into select-fields [n "" (str "(where (=null " source-name "/" key-name "_before )) ")])

        ]
    ;(clojure.pprint/pprint select-fields)
    [select-fields]
    )
  )

(defmethod p/expand-flow "map_before"
  [md-before mapping]
  ;(  mapping)
  (let [mapping (first mapping)
        n (get mapping :name)
        ; n (get mapping :name)
        [_ source-name key-name] (get mapping :transfer_fn)
        schema (p/get-source-schema md-before source-name)
        fields (get schema :fields)



        fields (sort-by (fn [m]
                          (if (= (get m :name) key-name)
                            0
                            1
                            )
                          ) fields)

        ;   _ (clojure.pprint/pprint fields)

        stage-name (str source-name "_stage")
        stage-name-tab (str stage-name "_tab")
        ;statge-enrich (str source-name "_stage")

        stage-mapping-fields (into [] (map (fn [field]
                                             (let [t (get-in field [:schema :type])]
                                               [stage-name
                                                (if (= (get field :name) key-name)
                                                  (str (get field :name) " string key ")
                                                  (str (get field :name) " " t))
                                                ""]))) fields)

        cust_stage_tab-fields [stage-name-tab "" (str "( latest_by_offset " stage-name " " key-name " )")]

        all-field (conj stage-mapping-fields cust_stage_tab-fields)

        ;;;;;;;;;;;;;;;;;;;;;;;;;

        enrich-fields (into all-field (map (fn [field]

                                             [n
                                              (get field :name)
                                              (str source-name "/" (get field :name))
                                              ]

                                             )) fields)


        enrich-fields_full (into enrich-fields (map (fn [field]
                                                      [n
                                                       (str (get field :name) "_before")
                                                       (str stage-name-tab "/" (get field :name))
                                                       ]

                                                      )) fields)

        enrich-fields_full (conj enrich-fields_full [n
                                                     ""
                                                     (str "(left_join " source-name "/" key-name " " stage-name-tab "/" "key_0 " " )")

                                                     ])
        insert-fields (into enrich-fields_full (map (fn [field]
                                                      [stage-name
                                                       (get field :name)
                                                       (str n "/" (get field :name))
                                                       ]

                                                      )) fields)
        ;    insert-fields (conj insert-fields [stage-name "" (str "( key " key-name  ")")   ])
        ;   _ (clojure.pprint/pprint insert-fields)
        insert-fields (into [] cat insert-fields)
        ]

    ;  (clojure.pprint/pprint (partition 3 insert-fields))
    [insert-fields]
    #_[stage-mapping-fields
       cust_stage_tab-fields
       enrich-fields_full
       insert-fields]))

#_(defmethod p/expand-flow "map_before2"
    [md-before mapping]
    ;(  mapping)
    (let [mapping (first mapping)
          n (get mapping :name)
          ; n (get mapping :name)
          [_ source-name key-name] (get mapping :transfer_fn)
          schema (p/get-source-schema md-before source-name)
          fields (get schema :fields)



          fields (sort-by (fn [m]
                            (if (= (get m :name) key-name)
                              0
                              1
                              )
                            ) fields)

          ;   _ (clojure.pprint/pprint fields)

          stage-name (str source-name "_stage")
          stage-name-tab (str stage-name "_tab")
          ;statge-enrich (str source-name "_stage")

          stage-mapping-fields (into [] (map (fn [field]
                                               (let [t (get-in field [:schema :type])]
                                                 [stage-name
                                                  (if (= (get field :name) key-name)
                                                    (str (get field :name) " string key ")
                                                    (str (get field :name) " " t))
                                                  ""]))) fields)

          cust_stage_tab-fields [stage-name-tab "" (str "( latest_by_offset " stage-name " " key-name " )")]

          all-field (conj stage-mapping-fields cust_stage_tab-fields)

          ;;;;;;;;;;;;;;;;;;;;;;;;;

          enrich-fields (into all-field (map (fn [field]

                                               [n
                                                (get field :name)
                                                (str source-name "/" (get field :name))
                                                ]

                                               )) fields)


          enrich-fields_full (into enrich-fields (map (fn [field]
                                                        [n
                                                         (str (get field :name) "_before")
                                                         (str stage-name-tab "/" (get field :name))
                                                         ]

                                                        )) fields)

          enrich-fields_full (conj enrich-fields_full [n
                                                       ""
                                                       (str "(left_join " source-name "/" key-name " " stage-name-tab "/" "key_0 " " )")

                                                       ])
          insert-fields (into enrich-fields_full (map (fn [field]
                                                        [stage-name
                                                         (get field :name)
                                                         (str n "/" (get field :name))
                                                         ]

                                                        )) fields)
          ;    insert-fields (conj insert-fields [stage-name "" (str "( key " key-name  ")")   ])
          ;   _ (clojure.pprint/pprint insert-fields)
          insert-fields (into [] cat insert-fields)
          ]

      ;  (clojure.pprint/pprint (partition 3 insert-fields))
      [insert-fields]
      #_[stage-mapping-fields
         cust_stage_tab-fields
         enrich-fields_full
         insert-fields]))


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defn flatten-mapping-impl [md-repo mapping]
  ;(println "--" mapping)
  (let [mapping (first mapping)
        [_ source-name] (get mapping :transfer_fn)
        ;     _ (println "---" source-name)

        source-schema (reduce (fn [acc v]
                                (if (= (clojure.string/lower-case source-name)
                                       (clojure.string/lower-case (get v :sink-name)))
                                  (reduced v)
                                  acc)
                                ) [] md-repo)

        ;    _ (when (= "body" source-name) (p/log-v w))
        source-fields (get source-schema :fields)
        source-fields (into [] (comp (filter (fn [m]
                                               (contains? #{"struct" "array"} (get-in m [:schema :type]))))
                                     (remove (fn [m]
                                               (and
                                                 (contains? #{"array"} (get-in m [:schema :type]))
                                                 (not= "struct" (get-in m [:schema :member_schema :type]))))))
                            source-fields)
        {:keys [source-array-fields source-struct-fields]} (group-by (fn [m]
                                                                       (if (= "array" (get-in m [:schema :type]))
                                                                         :source-array-fields
                                                                         :source-struct-fields)
                                                                       ) source-fields)
        mapping-for-struct (for [w source-struct-fields
                                 f (get-in w [:schema :fields])]
                             (let [t (if (= "struct" (get-in f [:schema :type]))
                                       (str source-name "_" (get w :name) "_" (get f :name) "_struct")
                                       (get-in f [:schema :type])
                                       )]
                               ;    (println "--" t)
                               [(str source-name "_" (get w :name))
                                (str (get f :name) " " t)
                                (str source-name "/" (get w :name) "->" (get f :name))]
                               )
                             )
        out-mapping (into [] mapping-for-struct)
        ;_ (p/log-v out-mapping)
        coll_postfix "_coll"

        v (for [w source-array-fields]
            [(str source-name "_" (get w :name) coll_postfix)
             (get w :name)
             (str "(explode " source-name "/" (get w :name) ")")])

        mapping-for-array (for [w source-array-fields
                                f (get-in w [:schema :member_schema :fields])]
                            [
                             ;(get w :name)
                             (str source-name "_" (get w :name))
                             (str (get f :name) " " (get-in f [:schema :type]))
                             (str source-name "_" (get w :name) coll_postfix "/" (get w :name) "->" (get f :name))])
        ;_ (clojure.pprint/pprint array-list)
        out-mapping (into out-mapping v)
        out-mapping (into out-mapping mapping-for-array)]

    ;    (clojure.pprint/pprint out-mapping)
    out-mapping))



(defmethod p/expand-flow "flatten"
  [schema-coll mapping]
  (let [out-mapping (flatten-mapping-impl schema-coll mapping)
        out-mapping (into [] cat out-mapping)]
    [out-mapping]))



(defn get-mapping-impl [schema-coll mapping]
  ;(println "--" mapping)
  (let [mapping (first mapping)
        [_ source-name source-ref-name] (get mapping :transfer_fn)
        ;     _ (println "---" source-name)
        sink-name (get mapping :name)
        ;  _ (println "--" sink-name)

        w (reduce (fn [acc v]
                    (if (= (clojure.string/lower-case source-name)
                           (clojure.string/lower-case (get v :sink-name)))
                      (reduced v)
                      acc)
                    ) [] schema-coll)

        ;    _ (when (= "body" source-name) (p/log-v w))
        fields (get w :fields)
        ;   _ (clojure.pprint/pprint fields)
        fields (into [] (comp
                          (filter (fn [m] (= (clojure.string/lower-case source-ref-name)
                                             (clojure.string/lower-case (get m :name)))))
                          (filter (fn [m]
                                    (contains? #{"struct" "array"} (get-in m [:schema :type]))))
                          (remove (fn [m]
                                    (and
                                      (contains? #{"array"} (get-in m [:schema :type]))
                                      (not= "struct" (get-in m [:schema :member_schema :type]))))))
                     fields)
        ;  _ (clojure.pprint/pprint fields)
        {:keys [source-array-fields source-struct-fields]} (group-by (fn [m]
                                                                       (if (= "array" (get-in m [:schema :type]))
                                                                         :source-array-fields
                                                                         :source-struct-fields)
                                                                       ) fields)
        struct-m (for [w source-struct-fields
                       f (get-in w [:schema :fields])]
                   (let [t (if (= "struct" (get-in f [:schema :type]))
                             (str source-name "_" (get w :name) "_" (get f :name) "_struct")
                             (get-in f [:schema :type])
                             )]
                     ;    (println "--" t)
                     [(str source-name "_" (get w :name))
                      (str (get f :name) " " t)
                      (str source-name "/" (get w :name) "->" (get f :name))]
                     )
                   )
        out-mapping (into [] struct-m)
        ;_ (p/log-v out-mapping)
        coll_postfix "_coll"

        v (for [w source-array-fields]
            [(str sink-name coll_postfix)
             (get w :name)
             (str "(explode " source-name "/" (get w :name) ")")])

        array-list (for [w source-array-fields
                         f (get-in w [:schema :member_schema :fields])]
                     (let [f-type (if (= "array"
                                         (get-in f [:schema :type]))

                                    (if (get-in f [:schema :member_schema :fields])
                                      (str source-name "_" (get w :name) "_" (get f :name) "_struct" " " (get-in f [:schema :type]))
                                      (str (get-in f [:schema :member_schema :type]) " " (get-in f [:schema :type])))
                                    (get-in f [:schema :type]))]
                       [sink-name
                        (str (get f :name) " " f-type)
                        (str sink-name coll_postfix "/" (get w :name) "->" (get f :name))]
                       )
                     )

        ;    _ (clojure.pprint/pprint array-list)
        out-mapping (into out-mapping v)
        out-mapping (into out-mapping array-list)]

    ; (clojure.pprint/pprint out-mapping)
    out-mapping))


(defmethod p/expand-flow "get"
  [schema-coll mapping]
  (let [out-mapping (get-mapping-impl schema-coll mapping)
        out-mapping (into [] cat out-mapping)]
    [out-mapping]))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


(defn distinct-impl2
  ([md-repo sink-name source-name group-by-source-key-list]
   (distinct-impl2 md-repo sink-name source-name group-by-source-key-list " 10 minutes "))
  ([md-repo sink-name source-name group-by-source-key-list window-str]
   (let [source-schema (reduce (fn [acc v]
                                 (if (= (clojure.string/lower-case source-name)
                                        (clojure.string/lower-case (get v :sink-name)))
                                   (reduced v)
                                   acc)
                                 ) [] md-repo)
         fields (get source-schema :fields)

         source-detected-tab_stage (str source-name "_distinct_stage_tab_stage")
         source-detected-table (str source-name "_distinct_stage_tab")
         source-detected-stream (str source-name "_distinct_stage")

         w (str "( concat " (clojure.string/join " " (into [] (comp (map :name)
                                                                    (map (fn [v]
                                                                           (str source-name "/" v)
                                                                           ))
                                                                    ) fields)) " )")

         out_mapping [source-detected-tab_stage "" (str "(select " source-name "/* ) " )
                      source-detected-tab_stage "key0" w
                      ]



         source-name source-detected-tab_stage

         out (into out_mapping [(str source-detected-table " table")
                                (str "key0" " string ")
                                (str " ( as_value " source-name "/key0" " ) " )
                                (str source-detected-table " ")
                                (str "key1" " string ")
                                (str  source-name "/key0 "  )
                                ])

         detected-key-fields (map (fn [f i]
                                    [
                                     #_[source-detected-table
                                      (str "key" (+ 1 i) " " (get-in f [:schema :type]))
                                      (str source-name "/" (get f :name))]
                                     [source-detected-table
                                      (str (get f :name) " " (get-in f [:schema :type]))
                                      (str "( latest_by_offset " source-name "/" (get f :name) " )")]]
                                    ) fields (range))

         detected-fields (into out (comp cat cat) detected-key-fields)

         windows [source-detected-table "" (str "(window " window-str ") ")]
         detected-fields (into detected-fields windows)

         group-by-str (->> (map (fn [f]
                                  (str source-name "/" (get f :name))
                                  ) fields)
                           (clojure.string/join ", "))
         group-by-str [source-detected-table "" (str "(group_by "  source-name  "/key0 )")]
         detected-fields (into detected-fields group-by-str)


         having-vec [source-detected-table "" (str "(having (= (count  " source-name "/key0 ) 1 ))")]
         detected-fields (into detected-fields having-vec)
         ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

         detected-stream-fields [(str source-detected-stream " stream " source-detected-table)
                                 (str "key0" " string ")
                                 ""]
         detected-stream-fields (into detected-stream-fields
                                      (comp (map (fn [f]
                                                   [source-detected-stream
                                                    (str (get f :name) " " (get-in f [:schema :type]))
                                                    ""]))
                                            cat)
                                      fields)

         ;detected-stream-fields (into [] cat detected-stream-fields)
         ;_ (clojure.pprint/pprint detected-stream-fields)


         all-fields (into detected-fields detected-stream-fields)


         ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

         ;stage-fields
         #_[(str source-name "_stage") "kk string" ""
            (str source-name "_stage") "value" ""
            (str source-name "_stage_tab") "" (str "(latest_by_offset " source-name "_stage kk)")
            (str source-name "_stage_tab") "" "(key key_0)"
            ;(str source-name "_stage_tab") ""  "(key kk )"
            ]

         ;    all-fields (into detected-fields stage-fields)

         ;     having-key (first group-by-key-list)
         distinct-fields (into [] (map (fn [f]
                                         [sink-name
                                          (str (get f :name) " " (get-in f [:schema :type]))
                                          (str source-detected-stream "/" (get f :name))]
                                         )) fields)


         ;vv1

         #_(str "(concat " (clojure.string/join " " (mapv (fn [v]
                                                            (str source-detected-stream "/" v)
                                                            ) group-by-key-list)) " )")

         distinct-fields-where [[sink-name "" (str "(where (!=null " source-detected-stream "/key0" "))")]
                                ;[sink-name "" (str "(left_join " vv1 " " source-name "_stage_tab" "/key_0" ")")]
                                ]

         ;_ (println "--"      [sink-name "" (str "(left_join " vv1 " "  source-name "_stage" "/kk" ")")])

         ;        distinct-fields-where (into distinct-fields-where distinct-fields-join)

         distinct-fields (into [] cat (into distinct-fields distinct-fields-where) #_(conj (into [] distinct-fields) distinct-fields-where))

         all-fields (into all-fields distinct-fields)


         ]

    ; (p/log-v (partition 3 all-fields) )

     [all-fields]))
  )





(defmethod p/expand-flow "distinct"
  [md-repo mapping]
  ;(println "--mapping" mapping)
  (let [mapping (first mapping)
        [_ source-name & group-by-key-list] (get mapping :transfer_fn)

        ;group-by-key-list (remove  )
        sink-name (get mapping :name)
        ;  _ (println "---" sink-name "--------------" source-name "---------" group-by-key-list)

        group-by-key-list (if (or (= "_" sink-name)
                                  (= "" sink-name))
                            #_(str source-name "_distinct")
                            (rest group-by-key-list)
                            group-by-key-list)

        sink-name (if (or (= "_" sink-name)
                          (= "" sink-name))
                    (str source-name "_distinct")
                    sink-name)]
    (distinct-impl2 md-repo sink-name source-name group-by-key-list)))



;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defn distinct-with-key-impl
  ([md-repo sink-name source-name group-by-source-key-list] (distinct-with-key-impl md-repo sink-name source-name group-by-source-key-list " 10 hours "))
  ([md-repo sink-name source-name group-by-source-key-list window-str]
   (let [w (reduce (fn [acc v]
                     (if (= (clojure.string/lower-case source-name)
                            (clojure.string/lower-case (get v :sink-name)))
                       (reduced v)
                       acc)
                     ) [] md-repo)

         ;    _ (when (= "body" source-name) (p/log-v w))
         fields (get w :fields)

         group-by-key-list (if (or
                                 (nil? group-by-source-key-list)
                                 (empty? group-by-source-key-list))
                             (mapv :name fields)
                             group-by-source-key-list)
         ; _ (println "-------------------------" group-by-source-key-list)

         source-detected-table (str source-name "_distinct_stage_tab")
         source-detected-stream (str source-name "_distinct_stage")


         group-by-key-set (into #{} group-by-key-list)

         k-ffield-list (into [] (filter (fn [f]
                                          (contains? group-by-key-set (get f :name))
                                          )) fields)
         ;  _ (clojure.pprint/pprint k-ffield-list)
         ;    "clicks_detected table" "key1" "clicks/ip_address"
         detected-key-fields (map (fn [f i]
                                    (if (= i 0)
                                      [(str source-detected-table " table")
                                       (str "key" i " " (get-in f [:schema :type]))
                                       (str source-name "/" (get f :name))
                                       ]
                                      [source-detected-table
                                       (str "key" i " " (get-in f [:schema :type]))
                                       (str source-name "/" (get f :name))
                                       ])
                                    ) k-ffield-list (range))

         detected-value-fields (into [] (map (fn [f]
                                               [source-detected-table
                                                (str (get f :name) " " (get-in f [:schema :type]))
                                                (str "( as_value " source-name "/" (get f :name) " )")]))
                                     k-ffield-list)

         detected-value-fields (into detected-value-fields
                                     (comp
                                       (remove (fn [f]
                                                 (contains? group-by-key-set (get f :name))
                                                 ))
                                       (map (fn [f]
                                              [source-detected-table
                                               (str (get f :name) " " (get-in f [:schema :type]))
                                               (str "( latest_by_offset " source-name "/" (get f :name) " )")]))
                                       )
                                     fields
                                     ;k-ffield-list

                                     )

         detected-fields (->> (into (into [] detected-key-fields) detected-value-fields)
                              (into [] cat))

         windows [source-detected-table "" (str "(window " window-str ") ")]
         detected-fields (into detected-fields windows)

         group-by-str (->> (map (fn [f]
                                  (str source-name "/" (get f :name))
                                  ) k-ffield-list)
                           (clojure.string/join ", "))
         group-by-str [source-detected-table "" (str "(group_by " group-by-str ")")]
         detected-fields (into detected-fields group-by-str)

         having-key (first group-by-key-list)
         having-vec [source-detected-table "" (str "(having (= (count " source-name "/" having-key " ) 1 ))")]
         detected-fields (into detected-fields having-vec)
         ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

         detected-stream-fields (map (fn [f i]
                                       (if (= i 0)
                                         [(str source-detected-stream " stream " source-detected-table)
                                          (str (get f :name) " " (get-in f [:schema :type]))
                                          ""]
                                         [source-detected-stream
                                          (str (get f :name) " " (get-in f [:schema :type]))
                                          ""])
                                       ) fields (range))
         all-fields (into detected-fields cat detected-stream-fields)

         ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

         ;stage-fields
         #_[(str source-name "_stage") "kk string" ""
            (str source-name "_stage") "value" ""
            (str source-name "_stage_tab") "" (str "(latest_by_offset " source-name "_stage kk)")
            (str source-name "_stage_tab") "" "(key key_0)"
            ;(str source-name "_stage_tab") ""  "(key kk )"
            ]

         ;    all-fields (into detected-fields stage-fields)


         distinct-fields (map (fn [f]
                                [sink-name
                                 (if (= (clojure.string/lower-case having-key)
                                        (clojure.string/lower-case (get f :name))
                                        )
                                   ;" key"
                                   (str (get f :name) " " (get-in f [:schema :type]))
                                   (str (get f :name) " " (get-in f [:schema :type]))
                                   )

                                 (str source-detected-stream "/" (get f :name))

                                 ]

                                ) fields)



         ;vv1

         #_(str "(concat " (clojure.string/join " " (mapv (fn [v]
                                                            (str source-detected-stream "/" v)
                                                            ) group-by-key-list)) " )")

         distinct-fields-where [[sink-name "" (str "(where (!=null " source-detected-stream "/" having-key "))")]
                                ;[sink-name "" (str "(left_join " vv1 " " source-name "_stage_tab" "/key_0" ")")]
                                ]

         ;_ (println "--"      [sink-name "" (str "(left_join " vv1 " "  source-name "_stage" "/kk" ")")])

         ;        distinct-fields-where (into distinct-fields-where distinct-fields-join)

         distinct-fields (into [] cat (into distinct-fields distinct-fields-where) #_(conj (into [] distinct-fields) distinct-fields-where))

         all-fields (into all-fields distinct-fields)


         ;vv
         #_(str "(concat " (clojure.string/join " " (mapv (fn [v]
                                                            (str sink-name "/" v)
                                                            ) group-by-key-list)) " )")
         ; ww

         #_[(str source-name "_stage") "kk" vv
            (str source-name "_stage") "value" vv]
         ; all-fields (into all-fields ww)

         ]

     [all-fields]))
  )


(defmethod p/expand-flow "distinct_with_time"
  [md-repo mapping]
  (let [mapping (first mapping)
        [_ source-name window-str & group-by-key-list] (get mapping :transfer_fn)
        ;_ (println "---" mapping)
        sink-name (get mapping :name)]
    (distinct-with-key-impl md-repo sink-name source-name group-by-key-list window-str)
    )
  )



(defmethod p/expand-flow "distinct_with_key"
  [md-repo mapping]
  ;(println "--mapping" mapping)
  (let [mapping (first mapping)
        [_ source-name & group-by-key-list] (get mapping :transfer_fn)

        ;group-by-key-list (remove  )
        sink-name (get mapping :name)
        ;  _ (println "---" sink-name "--------------" source-name "---------" group-by-key-list)

        group-by-key-list (if (or (= "_" sink-name)
                                  (= "" sink-name))
                            #_(str source-name "_distinct")
                            (rest group-by-key-list)
                            group-by-key-list)

        sink-name (if (or (= "_" sink-name)
                          (= "" sink-name))
                    (str source-name "_distinct")
                    sink-name)]
    (distinct-with-key-impl md-repo sink-name source-name group-by-key-list)))



(comment

  )



(defn impl-dv-mapping [md-repo s-name-postfix refined-entity-name]

  (let [sat-key-name "gdp_hashdiff"
        hub-key-name "hk"
        link-key-name "lhk"

        bk-postfix "_bk"
        ;  hk-prefix "hk_"
        tech-prefix "gdp_"
        ;   gdp-link "skip_hub"
        ;link-key-field "lhk"


        s-name-postfix (or s-name-postfix "")
        entity-name (clojure.string/replace refined-entity-name s-name-postfix "")

        sat-entity-name (str entity-name "_sat")
        hub-entity-name (str entity-name "_hub")
        link-entity-name (str entity-name "_link")

        ;  rename-key-m {(str hk-prefix entity-name) "hk"}


        refined-field-list (p/get-property-names md-repo refined-entity-name)
        tech-field-list (into [] (filter (fn [v] (clojure.string/starts-with? v tech-prefix))) refined-field-list)

        ;sat-field-set

        sat-field-map (if (contains? (into #{} refined-field-list) sat-key-name)
                        (into [] (comp
                                   (remove (fn [f] (contains? #{link-key-name} f))) ;; remove link key
                                   (remove (fn [f] (when (contains? (into #{} refined-field-list) link-key-name)
                                                     (clojure.string/ends-with? f (str "_" hub-key-name))
                                                     )))    ;; remove link key hash key
                                   (map (fn [f]
                                          (let [target-field (clojure.string/replace f bk-postfix "")
                                                target-field (if (or (= target-field sat-key-name)
                                                                     (= target-field link-key-name))
                                                               (str target-field " string key ")
                                                               target-field)]
                                            [sat-entity-name
                                             target-field
                                             (str refined-entity-name "/" f)])))
                                   cat
                                   ) refined-field-list)
                        [])

        hub-field-list (if (and
                             (contains? (into #{} refined-field-list) sat-key-name)
                             (not (contains? (into #{} refined-field-list) link-key-name))
                             )
                         (-> (into []
                                   (comp
                                     (filter (fn [v]
                                               (or
                                                 (= v hub-key-name)
                                                 (clojure.string/ends-with? v bk-postfix))
                                               )))
                                   refined-field-list)
                             (into tech-field-list))
                         []
                         )

        hub-field-map (into sat-field-map (comp
                                            (remove (fn [f] (contains? #{link-key-name sat-key-name} f)))
                                            (map (fn [f]
                                                   (let [target-field (clojure.string/replace f bk-postfix "")
                                                         target-field (if (= target-field hub-key-name)
                                                                        (str target-field " string key ")
                                                                        target-field)]
                                                     [hub-entity-name
                                                      target-field
                                                      (str refined-entity-name "/" f)])))
                                            cat
                                            ) hub-field-list)

        link-field-list (if (contains? (into #{} refined-field-list) link-key-name)
                          (-> (into [] (filter (fn [v]
                                                 (or
                                                   (= v link-key-name)
                                                   ; (clojure.string/starts-with? v "lhk")
                                                   (clojure.string/ends-with? v (str "_" hub-key-name)))
                                                 )) refined-field-list)
                              (into tech-field-list))
                          [])

        link-field-map (into hub-field-map
                             (comp
                               (remove (fn [f] (contains? #{sat-key-name} f)))
                               (map
                                 (fn [f]
                                   (let [target-field (if (= f link-key-name)
                                                        (str f " string key ")
                                                        f)]
                                     [link-entity-name target-field (str refined-entity-name "/" f)])))
                               cat
                               ) link-field-list)
        ;out [link-field-map]
        ]

    ;    (p/log-v (partition 3 link-field-map) )
    [link-field-map]

    )
  )


(defmethod p/expand-flow "map_data_vault"
  [md-repo mapping]
  (let [[w s-name] (p/get-object-value mapping)]
    (impl-dv-mapping md-repo s-name w)))



#_(defmethod p/expand-flow "as_data_vault"
    [md-repo mapping]
    (let [[s-name] (p/get-object-value mapping)
          out (->> (p/get-all-subject-names md-repo)
                   (into [] (comp (filter (fn [v] (clojure.string/ends-with? v s-name))))))

          hash-diff "gdp_hashdiff"
          f1 (fn [source-name]
               (let [t-name (clojure.string/replace source-name s-name "")]
                 [(str t-name "_distinct") "" (str "(distinct_with_time " source-name " \"2 MINUTES \" " hash-diff ")")
                  (str t-name "_map_before") "" (str "(map_before " t-name "_distinct " hash-diff " )")
                  (str t-name "_dv_stage") "" (str "(map_before_select_new " t-name "_map_before " hash-diff " )")]))
          w (into [] (comp (map f1) cat) out)
          w (into w ["_" "_" (str "( map_data_vault " "_dv_stage" ")")])]

      [["dummy" "x" ""]
       w]))


(defmethod p/expand-flow "apply"
  [md-repo mapping]
  (let [[op-name e] (p/get-object-value mapping)]
    (->> (p/get-all-subject-names md-repo)
         (into [["_dummy_" "x" ""]] (comp (filter (fn [v] (clojure.string/ends-with? v e)))
                                          (map (fn [w]
                                                 ["_" "_" (str "(" op-name " " w " " e ")") ";"]

                                                 ))
                                          ))
         ; (p/log-v)
         )))

