(ns ksql.gen.macro.expand-step-impl
  (:require [ksql.gen.protocol :as p]
            [ksql.gen.reader.mapping-reader :as mr]
            [ksql.gen.metadata_schema_gen :as sg]
            [ksql.gen.util :as u]))



#_(defmethod p/expand-step "add_default"
    [schema-coll selected-fields mapping-fields]
    (let []

      )

    )


(defn as-json-fields [source-name fields]
  (let [w (into [] (map (fn [f]
                          (str "'" f ":'" " (ifnull " source-name "/" f " 'null'" ")")
                          )) fields)
        out (clojure.string/join " ',' " w)]
    (str "(concat '{' " out "  '}'  )")))




(comment

  (as-json-fields "test" ["asd" "sdf"])

  )

(defmethod p/expand-step "as_json_value"
  [md-repo selected-fields w]
  (let [[n f [t source-name]] w
        schema (p/get-source-schema md-repo source-name)
        field-str (as-json-fields source-name (mapv :name (get schema :fields)))
        ]

    [n f field-str]

    ))




(defmethod p/expand-step "assoc_dv_attr"
  [md-repo selected-fields mapping]
  ;(println "--" dv)
  (let [[n f [f1 & dv-key-list] ] mapping]

    ;(println "--" selected-fields)
    ;(println "--" dv-key-list)
    (cond
      (= 2 (count dv-key-list))
      (let [
            [bk-target-name
             bk-source-name
             ] dv-key-list
            {:keys [gdp_src_sys_id gdp_oe_id gdp_pipeline_id]
             :or   {gdp_src_sys_id 1 gdp_oe_id 10 gdp_pipeline_id 100}
             } (get p/gcontext :dv-attr {})

            dv-attr1 (dissoc (get p/gcontext :dv-attr {}) :gdp_src_sys_id :gdp_oe_id :gdp_pipeline_id)
            additional-attr-m (into [] (comp (map (fn [[k v]]
                                                    [n (name k) (str v)]
                                                    ))
                                             cat) dv-attr1)
            ;gdp_src_sys_id 1
            ;gdp_oe_id 10
            ;gdp_pipeline_id 100
            e-name (first (clojure.string/split bk-source-name #"/"))

            fields (into [] (comp (remove (fn [f] (nil? (:field_name f) )) ) (map :transfer_fn) (map second)) selected-fields)
            fields (interpose "'~'" fields)
            gdp_hashdiff (str "( hash (concat " (clojure.string/join " " fields) " ) )")

            ]
        (into additional-attr-m
              [n (str bk-target-name "_bk") bk-source-name
               n "gdp_src_sys_id" (str "(cast '" gdp_src_sys_id "' integer)")
               n "gdp_oe_id" (str "(cast '" gdp_oe_id "' integer)")
               n "gdp_pipeline_id" (str "(cast '" gdp_pipeline_id "' integer)")
               n "gdp_load_ts" (str "(timestamptostring " e-name "/rowtime 'yyyy-MM-dd HH:mm:ss.SSSSSS')")
               n "gdp_uiss" (str "(concat " bk-source-name " '~' (cast this/gdp_oe_id string) '~' (cast this/gdp_src_sys_id string))")


               n "hk" "(hash this/gdp_uiss)"
               n "gdp_hashdiff" gdp_hashdiff]
              )

        )

      (= 4 (count dv-key-list))
      (let [[
             bk-target-link-name1
             bk-source-link-name1
             bk-target-link-name2
             bk-source-link-name2
             ] dv-key-list
            {:keys [gdp_src_sys_id gdp_oe_id gdp_pipeline_id]
             :or   {gdp_src_sys_id 1 gdp_oe_id 10 gdp_pipeline_id 100}
             } (get p/gcontext :dv-attr {})

            dv-attr1 (dissoc (get p/gcontext :dv-attr {}) :gdp_src_sys_id :gdp_oe_id :gdp_pipeline_id)
            additional-attr-m (into [] (comp (map (fn [[k v]]
                                                    [n (name k) (str v)]
                                                    ))
                                             cat) dv-attr1)
            ;gdp_src_sys_id 1
            ;gdp_oe_id 10
            ;gdp_pipeline_id 100
            e-name (first (clojure.string/split bk-source-link-name1 #"/"))
            ]

        (when-not bk-target-link-name1 (throw (Exception. "Business key bk-target-link-name1 is missing for assoc-dv-attr.")))
        (when-not bk-source-link-name1 (throw (Exception. "Business key bk-source-link-name1 is missing for assoc-dv-attr.")))
        (when-not bk-target-link-name2 (throw (Exception. "Business key bk-target-link-name2 is missing for assoc-dv-attr.")))
        (when-not bk-source-link-name2 (throw (Exception. "Business key bk-source-link-name2 is missing for assoc-dv-attr.")))
        (->> [
              ;n (str bk-target-name "_bk") bk-source-name
              n "gdp_src_sys_id" (str "(cast '" gdp_src_sys_id "' integer)")
              n "gdp_oe_id" (str "(cast '" gdp_oe_id "' integer)")
              n "gdp_pipeline_id" (str "(cast '" gdp_pipeline_id "' integer)")
              n "gdp_load_ts" (str "(timestamptostring " e-name "/rowtime 'yyyy-MM-dd HH:mm:ss.SSSSSS')")
              n "gdp_uiss" (str "(concat "
                                bk-source-link-name1 " '~' (cast this/gdp_oe_id string) '~' (cast this/gdp_src_sys_id string)"
                                bk-source-link-name2 " '~' (cast this/gdp_oe_id string) '~' (cast this/gdp_src_sys_id string)"
                                ")"
                                )
              n (str bk-target-link-name1 "_hk") (str "(hash (concat " bk-source-link-name1 " '~' (cast this/gdp_oe_id string) '~' (cast this/gdp_src_sys_id string)) )")
              n (str bk-target-link-name2 "_hk") (str "(hash (concat " bk-source-link-name2 " '~' (cast this/gdp_oe_id string) '~' (cast this/gdp_src_sys_id string)) )")
              n "lhk" "(hash this/gdp_uiss)"]
             (into additional-attr-m)
             ;(p/log-v)
             )
        )


      (= 6 (count dv-key-list))
      (let [[bk-target-name
             bk-source-name
             bk-target-link-name1
             bk-source-link-name1
             bk-target-link-name2
             bk-source-link-name2
             ] dv-key-list
            {:keys [gdp_src_sys_id gdp_oe_id gdp_pipeline_id]
             :or   {gdp_src_sys_id 1 gdp_oe_id 10 gdp_pipeline_id 100}
             } (get p/gcontext :dv-attr {})

            dv-attr1 (dissoc (get p/gcontext :dv-attr {}) :gdp_src_sys_id :gdp_oe_id :gdp_pipeline_id)
            additional-attr-m (into [] (comp (map (fn [[k v]]
                                                    [n (name k) (str v)]
                                                    ))
                                             cat) dv-attr1)
            ;gdp_src_sys_id 1
            ;gdp_oe_id 10
            ;gdp_pipeline_id 100
            e-name (first (clojure.string/split bk-source-name #"/"))]
        (when-not bk-target-name (throw (Exception. "Business key target-name is missing for assoc-dv-attr.")))
        (when-not bk-source-name (throw (Exception. "Business key source-name is missing for assoc-dv-attr.")))
        ;(when-not bk-target-name (throw (Exception. "Business key target-name is missing for assoc-dv-attr.")))
        ;(when-not bk-source-name (throw (Exception. "Business key source-name is missing for assoc-dv-attr.")))
        (when-not bk-target-link-name1 (throw (Exception. "Business key bk-target-link-name1 is missing for assoc-dv-attr.")))
        (when-not bk-source-link-name1 (throw (Exception. "Business key bk-source-link-name1 is missing for assoc-dv-attr.")))
        (when-not bk-target-link-name2 (throw (Exception. "Business key bk-target-link-name2 is missing for assoc-dv-attr.")))
        (when-not bk-source-link-name2 (throw (Exception. "Business key bk-source-link-name2 is missing for assoc-dv-attr.")))
        (into additional-attr-m
              [n (str bk-target-name "_bk") bk-source-name
               n "gdp_src_sys_id" (str "(cast '" gdp_src_sys_id "' integer)")
               n "gdp_oe_id" (str "(cast '" gdp_oe_id "' integer)")
               n "gdp_pipeline_id" (str "(cast '" gdp_pipeline_id "' integer)")
               n "gdp_load_ts" (str "(timestamptostring " e-name "/rowtime 'yyyy-MM-dd HH:mm:ss.SSSSSS')")
               n "gdp_uiss" (str "(concat " bk-source-name " '~' (cast this/gdp_oe_id string) '~' (cast this/gdp_src_sys_id string)"
                                 bk-source-link-name1 " '~' (cast this/gdp_oe_id string) '~' (cast this/gdp_src_sys_id string)"
                                 bk-source-link-name2 " '~' (cast this/gdp_oe_id string) '~' (cast this/gdp_src_sys_id string)"
                                 ")"
                                 )
               n (str bk-target-link-name1 "_hk")  (str "(hash (concat " bk-source-link-name1 " '~' (cast this/gdp_oe_id string) '~' (cast this/gdp_src_sys_id string)) )")
               n (str bk-target-link-name2 "_hk")  (str "(hash (concat " bk-source-link-name2 " '~' (cast this/gdp_oe_id string) '~' (cast this/gdp_src_sys_id string)) )")
               n "lhk" "(hash this/gdp_uiss)"
               n "gdp_hashdiff" "this/lhk"]))

      ;; only hk key

      :else
      (throw (Exception. "dv assoc attribute will be pair of 2 or 4 or 6"))

      )
    )
  )






(defmulti expand-step-internal (fn [_ _ mapping-fields] (first (get mapping-fields :transfer_fn))))

(defmethod expand-step-internal :default
  [_ _ m]
  (vector m))





(defmethod expand-step-internal "lookup"
  [_ _ mapping-field]
  (let [[t lookup-key w] (into [] (get mapping-field :transfer_fn))
        [_ source-key rel-key] (into [] w)]
    (vector
      (assoc mapping-field :transfer_fn (vector "as" lookup-key))
      (assoc mapping-field :transfer_fn (vector "left_join" source-key rel-key) :field_name nil))))


;latest_by_offset

(defmethod expand-step-internal "latest_by_offset"
  [md-repo selectd-fields mapping-field]
  ;(println "--rekey " )
  ;  (clojure.pprint/pprint (:field_type mapping-field))

  (if (:field_type mapping-field)
    [mapping-field]

    (let [sink-name (get mapping-field :name)
          [_ source-name key-name] (get mapping-field :transfer_fn)
          schema (p/get-source-schema md-repo source-name)
          fields (get schema :fields)
          fields (map (fn [field]
                        (if (= key-name (get field :name))
                          [(-> field
                               (assoc :name sink-name)
                               (assoc :field_name (str "key_0" " " #_(get-in field [:schema :type]))   #_(get field :name))
                               (dissoc :schema)
                               (assoc :transfer_fn ["as" (str source-name "/" (get field :name))])
                               )
                           (-> field
                               (assoc :name sink-name)
                               (assoc :field_name (str (get field :name) " " #_(get-in field [:schema :type])))
                               (dissoc :schema)
                               (assoc :transfer_fn ["as_value" (str source-name "/" (get field :name))])
                               )

                           ]

                          [(-> field
                               (assoc :name sink-name)
                               (assoc :field_name (str (get field :name) " " #_(get-in field [:schema :type])))
                               (dissoc :schema)
                               (assoc :transfer_fn ["latest_by_offset" (str source-name "/" (get field :name))])
                               )]
                          )
                        ) fields #_(range))
          fields (into [] cat fields)


          fields (into fields [{:name        sink-name
                                :transfer_fn ["key" "key_0"]}
                               {:name        sink-name
                                :transfer_fn ["group_by" key-name]}
                               {:name        sink-name
                                :transfer_fn ["type" "table"]}])]
      ;(clojure.pprint/pprint fields)

      fields

      )
    )

  )



(defmethod expand-step-internal "rekey"
  [schema-coll selectd-fields mapping-field]
  ;(println "--rekey " )
  (let [sink-name (get mapping-field :name)
        [_ source-name key-name] (get mapping-field :transfer_fn)
        schema (p/get-source-schema schema-coll source-name)
        fields (get schema :fields)
        fields (into []
                     (comp

                       (map (fn [field]

                              (-> field
                                  (assoc :name sink-name)
                                  (assoc :field_name (get field :name))
                                  (dissoc :schema)
                                  (assoc :transfer_fn ["as" (str source-name "/" (get field :name))])
                                  )
                              )))
                     fields)
        fields (into fields [{:name        sink-name
                              :transfer_fn ["key" key-name]}
                             {:name        sink-name
                              :transfer_fn ["ksql-gen-type" p/gen-ksql-rekey-stream-from-mapping]}])]

    fields

    )

  )




(defmethod expand-step-internal "select"
  [schema-coll selectd-fields mapping-field]
  ;(  selectd-fields)
  (let [field-names (rest (get mapping-field :transfer_fn))
        w (mapv (fn [v]
                  (clojure.string/split v #"/")
                  ) field-names)
        ;_ (println "--" w)
        entity-name (distinct (into [] (comp (map first)
                                             ) w))
        field-names (into #{} (distinct (into [] (comp
                                                   (map second)
                                                   (remove nil?)
                                                   (map clojure.string/upper-case)
                                                   ) w)))
        _ (when (< 1 (count entity-name))
            (throw (ex-info "select should be only one entity, found more than one " {:value entity-name})))
        ;_ (println "--fields names" field-names)
        source-name (clojure.string/lower-case (first entity-name))
        schema (p/get-source-schema schema-coll source-name)
        _ (when (nil? schema)
            (let [available-schema (clojure.string/join ",\n " (mapv :sink-name schema-coll))]
              (throw (ex-info (format "source schema is null for %s, available schema %s " source-name, available-schema) {:source mapping-field}))
              )
            )
        ;k (get schema :key)


        ;field-names (conj field-names k)

        fields (if (or
                     (empty? field-names)
                     (contains? field-names "*"))
                 (get schema :fields)
                 (into [] (filter (fn [v]
                                    (contains? field-names (clojure.string/upper-case (get v :name)))
                                    )) (get schema :fields))
                 )



        previous_field (into #{} (comp (map :field_name)
                                       (remove nil?)
                                       (map clojure.string/lower-case)) selectd-fields)


        fields (into []
                     (comp
                       (remove (fn [field]
                                 (contains? previous_field (clojure.string/lower-case (get field :name)))
                                 ))
                       (map (fn [field]

                              (-> field
                                  (assoc :name (get mapping-field :name))
                                  (assoc :field_name (get field :name))
                                  (dissoc :schema)
                                  (assoc :transfer_fn ["as" (str source-name "/" (get field :name))])))))
                     fields)
        ; _ (  fields)

        ]
    ;(println "---------------------" fields)
    ;[[]]
    fields
    )

  )

(defmethod expand-step-internal "where"
  [schema-coll mapping mapping-field]
  ;(  mapping-field)
  (let [field (into [] (comp (map :field_name)
                             (remove nil?)
                             (remove clojure.string/blank?)
                             ) mapping)]
    ; (println "--total count " (count field))

    (if (< 0 (count field))
      [mapping-field]
      (let [entity-name-list (->> mapping-field
                                  :transfer_fn
                                  (flatten)
                                  (filter (fn [v] (clojure.string/includes? v "/")))
                                  (map (fn [v]
                                         (first (clojure.string/split v #"/"))
                                         ))
                                  (distinct)
                                  )
            _ (when (< 1 (count entity-name-list))
                (throw (ex-info "select should be only one entity, found more than one " {:value entity-name-list}))
                )
            ;entity-name (first entity-name-list)
            source-name (clojure.string/lower-case (first entity-name-list))
            ; schema (get schema-m source-name)
            schema (p/get-source-schema schema-coll source-name)
            ; _ (  schema)
            fields (mapv (fn [field]
                           (-> field
                               (assoc :name (get mapping-field :name))
                               (assoc :field_name (get field :name))
                               (dissoc :schema)
                               (assoc :transfer_fn ["as" (str source-name "/" (get field :name))]))
                           ) (get schema :fields))

            fields (conj fields mapping-field)
            ;fields
            #_(conj fields {:name  (get mapping-field :name)
                            ; :transfer_fn ["generator-type" p/gen-ksql-stream-from-stream]
                            :topic (:topic schema)
                            })
            ]
        ;(println "--" source-name)
        fields
        )
      )

    )
  )




(comment



  (flatten ["where" ["=" "tnf_party/gender" "'F'" ["and "]]])

  )

