(ns ksqldb.client.protocol)


(defmulti invoke (fn [_ m] (get m :op)))

(defmethod invoke
  :default
  [client {:keys [op]}]
  (let [api-list (-> (into #{} (keys (methods invoke)))
                     (disj :default))]
    (throw (ex-info (str "api name " op " not found, available api \n" (clojure.string/join "\n" api-list)) {}))))


