(ns leiningen.new.clj-native-cmd
  (:use [leiningen.new.templates :only [renderer name-to-path sanitize-ns ->files]]))

(def render (renderer "clj-native-cmd"))

(defn clj-native-cmd
  [name]
  (let [data {:name name
              :ns-name (sanitize-ns name)
              :sanitized (name-to-path name)}]
    (->files data ["project.clj" (render "project.clj" data)]
["test/{{sanitized}}/core_test.clj" (render "test/clj_native_cmd/core_test.clj" data)]
["src/{{sanitized}}/core.clj" (render "src/clj_native_cmd/core.clj" data)]
)))