/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent;

import com.newrelic.agent.Agent;
import com.newrelic.agent.config.AgentConfig;
import com.newrelic.agent.config.AgentConfigChangeListener;
import com.newrelic.agent.config.Config;
import com.newrelic.agent.config.ConfigFileHelper;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import java.util.logging.XMLFormatter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AgentLogger
extends Logger
implements AgentConfigChangeListener {
    private static final String SIMPLE_LOG_FORMAT = "simple";
    private final Map<String, Logger> childLoggers = new HashMap<String, Logger>();
    private volatile AgentConfig agentConfig;
    private volatile String logFilePath;

    private AgentLogger(String name) {
        super(name, null);
    }

    static AgentLogger initialize(String name) {
        return new AgentLogger(name);
    }

    public Logger getChildLogger(Class<?> clazz) {
        return this.getChildLogger(clazz.getName(), clazz.getSimpleName());
    }

    public synchronized Logger getChildLogger(String fullName, String simpleName) {
        Object config;
        Object loggersConfig;
        SimpleLogger logger = new SimpleLogger(fullName, null);
        this.childLoggers.put(simpleName, logger);
        boolean configure = true;
        if (this.agentConfig != null && (loggersConfig = this.agentConfig.getProperty("loggers")) instanceof Map && (config = ((Map)loggersConfig).get(simpleName)) instanceof Map) {
            this.configureLogger(logger, new Config((Map)config));
            configure = false;
        }
        if (configure) {
            this.configureLogger(logger, new Config(Collections.emptyMap()));
        }
        return logger;
    }

    private void configureLogger(Logger logger, Config config) {
        Object logLevel = config.getProperty("log_level");
        if (logLevel != null) {
            logger.setLevel(AgentConfig.getLogLevel(logLevel.toString()));
        }
        boolean useParent = config.getProperty("use_parent", true);
        logger.setUseParentHandlers(useParent);
        logger.setParent(this);
        Object fileName = config.getProperty("file_name");
        if (fileName != null) {
            File logFile = this.getLogFile();
            logFile = new File(logFile.getParentFile(), fileName.toString());
            try {
                FileHandler handler = new FileHandler(logFile.getPath());
                logger.addHandler(handler);
                handler.setFormatter(this.getFormatter(this.agentConfig));
            }
            catch (Exception e) {
                this.log(Level.SEVERE, "Error initializing logger : {0}", e.toString());
            }
        }
        try {
            this.setFormatter(config, logger);
        }
        catch (Exception e) {
            Agent.LOG.log(Level.FINE, "Unable to set child logger format : {0}", e.toString());
        }
    }

    synchronized void configureLogger(AgentConfig agentConfig) {
        this.agentConfig = agentConfig;
        boolean debug = agentConfig.isDebugEnabled();
        File logFile = this.getLogFile();
        String logFileName = null;
        this.setUseParentHandlers(false);
        if (debug) {
            ConsoleHandler consoleHandler = new ConsoleHandler();
            consoleHandler.setLevel(Level.FINEST);
            this.addHandler(consoleHandler);
            this.setLevel(Level.FINEST);
        } else {
            this.setLevel(agentConfig.getLogLevel());
        }
        this.configureChildLoggers();
        try {
            logFileName = logFile.getPath();
            int limit = agentConfig.getProperty("log_limit_in_kbytes", 0) * 1024;
            int fileCount = Math.max(1, agentConfig.getProperty("log_file_count", 1));
            this.addHandler(new FileHandler(logFileName, limit, fileCount, true));
        }
        catch (IOException ex) {
            if (!debug) {
                this.addHandler(new ConsoleHandler());
            }
            this.log(Level.WARNING, "Unable to configure newrelic log file : {0}", logFile);
        }
        this.setFormatter(agentConfig, this);
        if (logFileName != null) {
            this.log(Level.INFO, "Writing to New Relic log file : {0}", logFileName);
        }
        if (debug) {
            this.config("Agent debug logging on");
        }
        this.logFilePath = logFileName;
    }

    private Formatter getFormatter(Config config) {
        String format = config.getProperty("log_format", SIMPLE_LOG_FORMAT);
        if (SIMPLE_LOG_FORMAT.equals(format)) {
            return new LogFormatter();
        }
        if ("xml".equals(format)) {
            return new XMLFormatter();
        }
        return new SimpleFormatter();
    }

    private void setFormatter(Config config, Logger agentLogger) {
        Formatter formatter = this.getFormatter(config);
        for (Handler handler : this.getHandlers()) {
            handler.setFormatter(formatter);
        }
    }

    private void configureChildLoggers() {
        Object loggersConfig = this.agentConfig.getProperty("loggers");
        if (loggersConfig instanceof Map) {
            Set entries = ((Map)loggersConfig).entrySet();
            for (Map.Entry entry : entries) {
                Logger logger = this.childLoggers.get(entry.getKey());
                if (logger == null || !(entry.getValue() instanceof Map)) continue;
                this.configureLogger(logger, new Config((Map)entry.getValue()));
            }
        }
    }

    public String getLogFilePath() {
        return this.logFilePath;
    }

    private File getLogFile() {
        String logFileName;
        block3: {
            logFileName = System.getProperty("newrelic.logfile");
            if (logFileName != null) {
                File f = new File(logFileName);
                try {
                    f.createNewFile();
                    return f;
                }
                catch (Exception e) {
                    String msg = MessageFormat.format("Unable to create log file: ", logFileName);
                    this.severe(msg);
                    this.log(Level.FINER, e.getMessage(), e);
                    System.err.println("NewRelic Agent: " + msg);
                    if (!Agent.isDebugEnabled()) break block3;
                    e.printStackTrace();
                }
            }
        }
        logFileName = this.agentConfig.getProperty("log_file_name", "newrelic_agent.log");
        File agentLogDirectory = this.getLogDirectory();
        return new File(agentLogDirectory, logFileName);
    }

    private File getLogDirectory() {
        File nrDir;
        String logFilePath = (String)this.agentConfig.getProperty("log_file_path");
        if (logFilePath != null) {
            File path = new File(logFilePath);
            if (path.exists()) {
                return path;
            }
            System.out.println(MessageFormat.format("The log_file_path {0} specified in newrelic.yml does not exist", logFilePath));
        }
        if ((nrDir = ConfigFileHelper.getNewRelicDirectory()) != null && nrDir.exists()) {
            File logs = new File(nrDir, "logs");
            logs.mkdir();
            return logs;
        }
        File logs = new File("logs");
        if (logs.exists()) {
            return logs;
        }
        return new File(".");
    }

    @Override
    public void configChanged(AgentConfig config) {
        this.setLevel(config.getLogLevel());
    }

    private static class SimpleLogger
    extends Logger {
        protected SimpleLogger(String name, String resourceBundleName) {
            super(name, resourceBundleName);
        }
    }

    private static class LogFormatter
    extends Formatter {
        Date dat = new Date();
        private static final String format = "{0,date} {0,time}";
        private MessageFormat formatter;
        private Object[] args = new Object[1];
        private final String lineSeparator = System.getProperty("line.separator");

        private LogFormatter() {
        }

        public synchronized String format(LogRecord record) {
            StringBuilder sb = new StringBuilder();
            this.dat.setTime(record.getMillis());
            this.args[0] = this.dat;
            StringBuffer text = new StringBuffer();
            if (this.formatter == null) {
                this.formatter = new MessageFormat(format);
            }
            this.formatter.format(this.args, text, (FieldPosition)null);
            sb.append(text);
            sb.append(" NewRelic ");
            String message = this.formatMessage(record);
            sb.append(record.getLevel().getLocalizedName());
            sb.append(": ");
            sb.append(message);
            sb.append(this.lineSeparator);
            if (record.getThrown() != null) {
                try {
                    StringWriter sw = new StringWriter();
                    PrintWriter pw = new PrintWriter(sw);
                    record.getThrown().printStackTrace(pw);
                    pw.close();
                    sb.append(sw.toString());
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            return sb.toString();
        }
    }
}

