/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent;

import com.newrelic.agent.Agent;
import com.newrelic.agent.Instrumentation5;
import com.newrelic.agent.Instrumentation6;
import com.newrelic.agent.config.AgentConfig;
import com.newrelic.agent.instrumentation.InstrumentedClass;
import com.newrelic.agent.service.ServiceManagerFactory;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.instrument.ClassDefinition;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.Instrumentation;
import java.lang.instrument.UnmodifiableClassException;
import java.util.ArrayList;
import java.util.jar.JarFile;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class InstrumentationProxy
implements Instrumentation {
    private final Instrumentation instrumentation;
    private final boolean bootstrapClassIntrumentationEnabled;

    protected InstrumentationProxy(Instrumentation instrumentation, boolean defaultValue) {
        this.instrumentation = instrumentation;
        AgentConfig config = ServiceManagerFactory.getServiceManager().getConfigService().getAgentConfig();
        this.bootstrapClassIntrumentationEnabled = config.getProperty("enable_bootstrap_class_instrumentation", defaultValue);
    }

    public static InstrumentationProxy getInstrumentationProxy(Instrumentation inst) {
        if (inst == null) {
            return null;
        }
        String version = System.getProperty("java.version");
        char minor = version.charAt(2);
        return minor >= '6' ? new Instrumentation6(inst) : new Instrumentation5(inst);
    }

    protected Instrumentation getInstrumentation() {
        return this.instrumentation;
    }

    @Override
    public void addTransformer(ClassFileTransformer transformer) {
        this.instrumentation.addTransformer(transformer);
    }

    @Override
    public Class[] getAllLoadedClasses() {
        return this.instrumentation.getAllLoadedClasses();
    }

    @Override
    public Class[] getInitiatedClasses(ClassLoader loader) {
        return this.instrumentation.getInitiatedClasses(loader);
    }

    @Override
    public long getObjectSize(Object objectToSize) {
        if (objectToSize instanceof Serializable) {
            ByteArrayOutputStream oStream = new ByteArrayOutputStream();
            try {
                new ObjectOutputStream(oStream).writeObject(objectToSize);
                oStream.close();
                return oStream.size();
            }
            catch (IOException e) {
                Agent.LOG.log(Level.FINER, "Unable to get object size", e);
                return 0L;
            }
        }
        return this.instrumentation.getObjectSize(objectToSize);
    }

    @Override
    public boolean isRedefineClassesSupported() {
        return this.instrumentation.isRedefineClassesSupported();
    }

    @Override
    public void redefineClasses(ClassDefinition[] definitions) throws ClassNotFoundException, UnmodifiableClassException {
        this.instrumentation.redefineClasses(definitions);
    }

    @Override
    public boolean removeTransformer(ClassFileTransformer transformer) {
        return this.instrumentation.removeTransformer(transformer);
    }

    @Override
    public abstract void addTransformer(ClassFileTransformer var1, boolean var2);

    @Override
    public abstract void appendToBootstrapClassLoaderSearch(JarFile var1);

    @Override
    public abstract void appendToSystemClassLoaderSearch(JarFile var1);

    @Override
    public abstract boolean isModifiableClass(Class<?> var1);

    @Override
    public abstract boolean isNativeMethodPrefixSupported();

    @Override
    public abstract boolean isRetransformClassesSupported();

    public Class<?>[] retransformUninstrumentedClasses(String ... classNames) throws UnmodifiableClassException, ClassNotFoundException {
        if (!this.isRetransformClassesSupported()) {
            return new Class[0];
        }
        ArrayList classList = new ArrayList(classNames.length);
        for (String className : classNames) {
            Class<?> clazz = Class.forName(className);
            if (clazz.getAnnotation(InstrumentedClass.class) != null) continue;
            classList.add(clazz);
        }
        Class[] classArray = classList.toArray(new Class[0]);
        this.retransformClasses(classArray);
        return classArray;
    }

    @Override
    public abstract void retransformClasses(Class<?> ... var1) throws UnmodifiableClassException;

    @Override
    public abstract void setNativeMethodPrefix(ClassFileTransformer var1, String var2);

    public abstract int getClassReaderFlags();

    public abstract int getMinorJVMVersion();

    public final boolean isBootstrapClassInstrumentationEnabled() {
        return this.bootstrapClassIntrumentationEnabled;
    }
}

