/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent;

import com.newrelic.agent.ConnectionListener;
import com.newrelic.agent.IRPMService;
import com.newrelic.agent.RPMService;
import com.newrelic.agent.RPMServiceManager;
import com.newrelic.agent.config.AgentConfig;
import com.newrelic.agent.service.AbstractService;
import com.newrelic.agent.service.ServiceManagerFactory;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RPMServiceManagerImpl
extends AbstractService
implements RPMServiceManager {
    private final IRPMService defaultRPMService;
    private final Map<String, IRPMService> appNameToRPMService = new ConcurrentHashMap<String, IRPMService>();
    private final List<ConnectionListener> connectionListeners = new CopyOnWriteArrayList<ConnectionListener>();
    private final ConnectionListener connectionListener = new ConnectionListener(){

        @Override
        public void connected(IRPMService rpmService, Map<String, Object> connectionInfo) {
            for (ConnectionListener each : RPMServiceManagerImpl.this.connectionListeners) {
                each.connected(rpmService, connectionInfo);
            }
        }

        @Override
        public void disconnected(IRPMService rpmService) {
            for (ConnectionListener each : RPMServiceManagerImpl.this.connectionListeners) {
                each.disconnected(rpmService);
            }
        }
    };
    private volatile List<IRPMService> rpmServices;

    public RPMServiceManagerImpl() {
        super(RPMServiceManager.class.getSimpleName());
        AgentConfig config = ServiceManagerFactory.getServiceManager().getConfigService().getAgentConfig();
        String host = config.getHost();
        String port = Integer.toString(config.getPort());
        this.getLogger().config(MessageFormat.format("Configured to connect to RPM at {0}:{1}", host, port));
        String appName = config.getApplicationName();
        this.defaultRPMService = new RPMService(appName, this.connectionListener);
        ArrayList<IRPMService> list = new ArrayList<IRPMService>(1);
        list.add(this.defaultRPMService);
        this.rpmServices = Collections.unmodifiableList(list);
    }

    @Override
    protected synchronized void doStart() throws Exception {
        for (IRPMService rpmService : this.rpmServices) {
            rpmService.start();
        }
    }

    @Override
    protected synchronized void doStop() throws Exception {
        for (IRPMService rpmService : this.rpmServices) {
            rpmService.stop();
        }
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    public void addConnectionListener(ConnectionListener listener) {
        this.connectionListeners.add(listener);
    }

    @Override
    public void removeConnectionListener(ConnectionListener listener) {
        this.connectionListeners.remove(listener);
    }

    @Override
    public IRPMService getRPMService() {
        return this.defaultRPMService;
    }

    @Override
    public IRPMService getRPMService(String appName) {
        if (appName == null || this.defaultRPMService.getApplicationName() == appName) {
            return this.defaultRPMService;
        }
        return this.appNameToRPMService.get(appName);
    }

    @Override
    public IRPMService getOrCreateRPMService(String appName) {
        IRPMService rpmService = this.getRPMService(appName);
        if (rpmService != null) {
            return rpmService;
        }
        return this.createRPMServiceForAppName(appName);
    }

    private synchronized IRPMService createRPMServiceForAppName(String appName) {
        IRPMService rpmService = this.getRPMService(appName);
        if (rpmService == null) {
            rpmService = new RPMService(appName, this.connectionListener);
            this.appNameToRPMService.put(appName, rpmService);
            ArrayList<IRPMService> list = new ArrayList<IRPMService>(this.appNameToRPMService.size() + 1);
            list.addAll(this.appNameToRPMService.values());
            list.add(this.defaultRPMService);
            this.rpmServices = Collections.unmodifiableList(list);
            if (this.isStarted()) {
                try {
                    rpmService.start();
                }
                catch (Exception e) {
                    String msg = MessageFormat.format("Error starting RPM Service for {0}: {1}", rpmService.getApplicationName(), e);
                    this.getLogger().severe(msg);
                }
            }
        }
        return rpmService;
    }

    @Override
    public List<IRPMService> getRPMServices() {
        return this.rpmServices;
    }
}

