/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent;

import com.newrelic.agent.IAgent;
import com.newrelic.agent.IRPMService;
import com.newrelic.agent.InstrumentationProxy;
import com.newrelic.agent.service.AbstractService;
import com.newrelic.agent.service.ServiceManager;
import com.newrelic.agent.service.ServiceManagerFactory;
import com.newrelic.agent.util.Streams;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

public class ReplayAgent {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        block9: {
            if (args.length < 2) {
                System.err.println("Usage: ReplayAgent method_name path_to_data_file [interval_in_seconds]");
                return;
            }
            final String method = args[0];
            String fileName = args[1];
            File file = new File(fileName);
            FileInputStream iStream = new FileInputStream(file);
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            Streams.copy(iStream, output);
            final String data = output.toString();
            boolean loop = args.length > 2;
            try {
                ReplayAgent.start();
                final IRPMService service = ServiceManagerFactory.getServiceManager().getRPMServiceManager().getRPMService();
                if (loop) {
                    Runnable command = new Runnable(){

                        public void run() {
                            try {
                                System.out.println(service.invokeRemote(method, false, data));
                            }
                            catch (Exception e) {
                                throw new RuntimeException(e);
                            }
                        }
                    };
                    long period = Long.parseLong(args[2]);
                    Executors.newSingleThreadScheduledExecutor().scheduleAtFixedRate(command, 0L, period, TimeUnit.SECONDS);
                    IRPMService iRPMService = service;
                    synchronized (iRPMService) {
                        service.wait();
                        break block9;
                    }
                }
                System.out.println(service.invokeRemote(method, false, data));
            }
            finally {
                if (!loop) {
                    ServiceManagerFactory.getServiceManager().getAgent().shutdownAsync();
                }
            }
        }
    }

    private static void start() throws Exception {
        FakeAgent agent = new FakeAgent();
        ServiceManager serviceManager = ServiceManagerFactory.create(agent);
        serviceManager.start();
        ServiceManagerFactory.getServiceManager().getRPMServiceManager().getRPMService().launch();
        Thread.sleep(2000L);
    }

    private static class FakeAgent
    extends AbstractService
    implements IAgent {
        protected FakeAgent() {
            super(IAgent.class.getSimpleName());
        }

        public InstrumentationProxy getInstrumentation() {
            return null;
        }

        public void shutdown() {
        }

        public void shutdownAsync() {
        }

        protected void doStart() throws Exception {
        }

        protected void doStop() throws Exception {
        }

        public boolean isEnabled() {
            return true;
        }
    }
}

