/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent;

import com.newrelic.agent.Agent;
import com.newrelic.agent.Transaction;
import com.newrelic.agent.extension.ConfigurationConstruct;
import com.newrelic.agent.extension.ExtensionService;
import com.newrelic.agent.instrumentation.yaml.PointCutFactory;
import com.newrelic.agent.service.AbstractService;
import com.newrelic.agent.service.ServiceManagerFactory;
import com.newrelic.agent.tracers.ClassMethodSignature;
import com.newrelic.agent.tracers.IgnoreTransactionTracerFactory;
import com.newrelic.agent.tracers.SkipTracer;
import com.newrelic.agent.tracers.SkipTracerException;
import com.newrelic.agent.tracers.Tracer;
import com.newrelic.agent.tracers.TracerFactory;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TracerService
extends AbstractService {
    private final Map<String, TracerFactory> tracerFactories = new ConcurrentHashMap<String, TracerFactory>();
    private final Map<Class, Set<String>> classTracerFactories = Collections.synchronizedMap(new HashMap());

    public TracerService() {
        super(TracerService.class.getSimpleName());
        this.registerTracerFactory(IgnoreTransactionTracerFactory.TRACER_FACTORY_NAME, new IgnoreTransactionTracerFactory());
        ExtensionService extensionService = ServiceManagerFactory.getServiceManager().getExtensionService();
        for (ConfigurationConstruct construct : PointCutFactory.getConstructs()) {
            extensionService.addConstruct(construct);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Tracer getTracer(String tracerFactoryName, String[] possibleFactories, String className, String methodName, String methodDesc, Object object, Object ... args) {
        if (!ServiceManagerFactory.getServiceManager().isStarted()) {
            return null;
        }
        if (ServiceManagerFactory.getServiceManager().getThreadService().isAgentThreadId(Thread.currentThread().getId())) {
            return null;
        }
        Transaction transaction = Transaction.getTransaction();
        try {
            if (transaction.isOverSizeLimit() || transaction.isIgnore()) {
                Tracer tracer = null;
                return tracer;
            }
            ClassMethodSignature signature = new ClassMethodSignature(className, methodName, methodDesc);
            Tracer tracer = this.getTracer(transaction, tracerFactoryName, possibleFactories, signature, object, args);
            if (tracer != null && !(tracer instanceof SkipTracer)) {
                Tracer tracer2 = transaction.tracerStarted(tracer);
                return tracer2;
            }
            Tracer tracer3 = tracer;
            return tracer3;
        }
        finally {
            if (transaction.isTracerStackEmpty()) {
                Transaction.clearTransaction();
            }
        }
    }

    public Tracer getTracer(Transaction transaction, String tracerFactoryName, String[] possibleFactories, ClassMethodSignature signature, Object object, Object[] args) {
        TracerFactory factory;
        block14: {
            if (tracerFactoryName == null) {
                if (possibleFactories == null || possibleFactories.length == 0) {
                    return null;
                }
                Set<String> factories = this.getClassFactories(object.getClass(), signature.getClassName());
                if (factories == null || factories.isEmpty()) {
                    return null;
                }
                HashSet<String> possible = new HashSet<String>(Arrays.asList(possibleFactories));
                possible.retainAll(factories);
                if (possible.isEmpty()) {
                    return null;
                }
                tracerFactoryName = (String)possible.iterator().next();
                if (possible.size() > 1 && Agent.isDebugEnabled()) {
                    this.getLogger().log(Level.FINER, "{0}.{1} was instrumented by multiple factories: {2}", new Object[]{signature.getClassName(), signature.getMethodName(), possible});
                }
            }
            if ((factory = this.getTracerFactory(tracerFactoryName)) == null) {
                try {
                    Class<?> tracerFactoryClass = Class.forName(tracerFactoryName);
                    if (TracerFactory.class.isAssignableFrom(tracerFactoryClass)) {
                        factory = (TracerFactory)tracerFactoryClass.newInstance();
                        this.registerTracerFactory(tracerFactoryName, factory);
                    } else {
                        Agent.LOG.log(Level.FINER, "{0} does not implement TracerFactory", tracerFactoryName);
                    }
                }
                catch (Throwable e) {
                    this.getLogger().log(Level.SEVERE, "Unable to instantiate factory {0} ; {1}", new Object[]{tracerFactoryName, e.getMessage()});
                    if (!Agent.isDebugEnabled()) break block14;
                    this.getLogger().log(Level.FINEST, e.getMessage(), e);
                }
            }
        }
        Tracer tracer = null;
        if (factory == null) {
            this.getLogger().log(Level.FINER, "No tracer factory for {0}:{1}:{2}", new Object[]{tracerFactoryName, signature.getClassName(), signature.getMethodName()});
        } else {
            try {
                tracer = factory.getTracer(transaction, signature, object, args);
            }
            catch (SkipTracerException e) {
                // empty catch block
            }
        }
        return tracer;
    }

    private Set<String> getClassFactories(Class<? extends Object> clazz, String className) {
        while (clazz != null) {
            if (clazz.getName().equals(className)) {
                return this.classTracerFactories.get(clazz);
            }
            clazz = clazz.getSuperclass();
        }
        return null;
    }

    private TracerFactory getTracerFactory(String tracerFactoryName) {
        return this.tracerFactories.get(tracerFactoryName);
    }

    public void registerTracerFactory(TracerFactory tracerFactory) {
        this.tracerFactories.put(tracerFactory.getClass().getName(), tracerFactory);
    }

    public void registerTracerFactory(String name, TracerFactory tracerFactory) {
        this.tracerFactories.put(name.intern(), tracerFactory);
    }

    @Override
    protected void doStart() {
    }

    @Override
    protected void doStop() {
        this.tracerFactories.clear();
        this.classTracerFactories.clear();
    }

    public void registerClassTracerFactories(Class<?> clazz, Set<String> factoryNames) {
        this.classTracerFactories.put(clazz, factoryNames);
    }

    @Override
    public boolean isEnabled() {
        return true;
    }
}

