/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent;

import com.newrelic.agent.Agent;
import com.newrelic.agent.HarvestListener;
import com.newrelic.agent.IRPMService;
import com.newrelic.agent.MetricSpec;
import com.newrelic.agent.Transaction;
import com.newrelic.agent.TransactionData;
import com.newrelic.agent.TransactionListener;
import com.newrelic.agent.config.AgentConfig;
import com.newrelic.agent.service.AbstractService;
import com.newrelic.agent.service.ServiceManager;
import com.newrelic.agent.service.ServiceManagerFactory;
import com.newrelic.agent.stats.StatsEngine;
import com.newrelic.agent.tracers.DispatcherTracer;
import com.newrelic.agent.tracers.RequestDispatcherTracer;
import com.newrelic.agent.tracers.Tracer;
import com.newrelic.agent.util.DefaultThreadFactory;
import com.newrelic.agent.util.LatchingRunnable;
import com.newrelic.agent.util.TimeConversion;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransactionService
extends AbstractService
implements HarvestListener {
    private static final long REPORT_STALL_ERROR_THRESHOLD_IN_NANOSECONDS = TimeUnit.NANOSECONDS.convert(300L, TimeUnit.SECONDS);
    private final ExecutorService executor;
    private final List<TransactionListener> transactionListeners = new CopyOnWriteArrayList<TransactionListener>();
    private final Map<Long, RunningTransaction> transactionThreadMap = new ConcurrentHashMap<Long, RunningTransaction>();
    private final long stallThresholdInNanoseconds;

    public TransactionService() {
        super(TransactionService.class.getSimpleName());
        AgentConfig config = ServiceManagerFactory.getServiceManager().getConfigService().getAgentConfig();
        double stallThresholdInSeconds = config.getProperty("stall_threshold", 30.0);
        this.stallThresholdInNanoseconds = TimeConversion.convertSecondsToNanos(stallThresholdInSeconds);
        this.executor = this.createExecutor(config);
    }

    private ExecutorService createExecutor(AgentConfig config) {
        DefaultThreadFactory threadFactory = new DefaultThreadFactory("New Relic Transaction Service", true);
        int maxPendingTxs = config.getProperty("max_pending_transactions", 32);
        ArrayBlockingQueue<Runnable> workQueue = maxPendingTxs > 0 ? new ArrayBlockingQueue(maxPendingTxs) : new LinkedBlockingQueue();
        return new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, workQueue, threadFactory);
    }

    public void processTransaction(IRPMService service, TransactionData transactionData) {
        try {
            this.executor.execute(new FinishTransaction(service, transactionData));
        }
        catch (RejectedExecutionException e) {
            Level level = transactionData.getRootTracer() instanceof DispatcherTracer ? Level.SEVERE : Level.FINE;
            this.getLogger().log(level, "Unable to record transaction \"{0}\" because of a job executor rejection", transactionData.getBlameMetricName());
        }
    }

    @Override
    protected void doStart() {
        ServiceManagerFactory.getServiceManager().getHarvestService().addHarvestListener(this);
    }

    @Override
    protected void doStop() {
        this.transactionListeners.clear();
        this.transactionThreadMap.clear();
        try {
            this.executor.shutdownNow();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void addTransaction(Transaction tx) {
        this.transactionThreadMap.put(tx.getThreadId(), new RunningTransaction(tx));
    }

    public void removeTransaction() {
        this.transactionThreadMap.remove(Thread.currentThread().getId());
    }

    public Set<Long> getRunningThreadsIds() {
        return new HashSet<Long>(this.transactionThreadMap.keySet());
    }

    public void addTransactionListener(TransactionListener listener) {
        this.transactionListeners.add(listener);
    }

    public void removeTransactionListener(TransactionListener listener) {
        this.transactionListeners.remove(listener);
    }

    public void waitForTransactionsToFinish() throws RejectedExecutionException {
        LatchingRunnable runnable = new LatchingRunnable();
        this.executor.execute(runnable);
        runnable.block();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void beforeHarvest(IRPMService service) {
        if (this.getLogger().isLoggable(Level.FINER)) {
            this.getLogger().finer("Checking for stalled transactions");
        }
        int stallCount = 0;
        for (RunningTransaction runningTransaction : this.transactionThreadMap.values()) {
            Transaction transaction = runningTransaction.getTransaction();
            if (transaction.isIgnore()) continue;
            long threadUserTimeInNanoseconds = runningTransaction.getRunningTime();
            if (threadUserTimeInNanoseconds > this.stallThresholdInNanoseconds) {
                ++stallCount;
            }
            if (threadUserTimeInNanoseconds <= REPORT_STALL_ERROR_THRESHOLD_IN_NANOSECONDS) continue;
            transaction.reportAsStall();
        }
        if (stallCount > 0) {
            StatsEngine statsEngine = service.getStatsEngine();
            Object object = statsEngine.getHarvestLock();
            synchronized (object) {
                statsEngine.getStats("Stalls").incrementCallCount(stallCount);
            }
            if (Agent.isDebugEnabled()) {
                System.err.println("Stall count: " + stallCount);
            }
        }
    }

    @Override
    public void afterHarvest(IRPMService rpmService) {
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    private static class RunningTransaction {
        private final Transaction tx;
        private final long startTimeInNanoseconds;

        public RunningTransaction(Transaction tx) {
            this.tx = tx;
            this.startTimeInNanoseconds = System.nanoTime();
        }

        public Transaction getTransaction() {
            return this.tx;
        }

        public long getRunningTime() {
            return System.nanoTime() - this.startTimeInNanoseconds;
        }
    }

    private class FinishTransaction
    implements Runnable {
        private final IRPMService rpmService;
        private final TransactionData transactionData;

        public FinishTransaction(IRPMService rpmService, TransactionData transactionData) {
            this.rpmService = rpmService;
            this.transactionData = transactionData;
        }

        public void run() {
            try {
                this.doRun();
            }
            catch (Throwable t) {
                if (TransactionService.this.getLogger().isLoggable(Level.FINER)) {
                    TransactionService.this.getLogger().log(Level.FINER, MessageFormat.format("Failed to finish transaction {0}", t), t);
                }
                TransactionService.this.getLogger().severe(MessageFormat.format("Failed to finish transaction {0}", t));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void doRun() {
            ServiceManager serviceManager = ServiceManagerFactory.getServiceManager();
            if (!serviceManager.isStarted() || !serviceManager.getAgent().isEnabled()) {
                return;
            }
            if (Agent.isDebugEnabled()) {
                TransactionService.this.getLogger().finer("Recording metrics for " + this.transactionData);
            }
            MetricSpec transactionSizeMetric = MetricSpec.lookup("Supportability/TransactionSize");
            boolean sizeLimitExceeded = this.transactionData.getParameters().get("size_limit") != null;
            Object object = this.rpmService.getStatsEngine().getHarvestLock();
            synchronized (object) {
                this.recordMetrics();
                this.rpmService.getStatsEngine().getStats(transactionSizeMetric).recordDataPoint(this.transactionData.getTransactionSize());
                if (sizeLimitExceeded) {
                    this.rpmService.getStatsEngine().getStats("Supportability/TransactionSizeClamp").incrementCallCount();
                }
            }
            if (this.transactionData.getRootTracer() instanceof RequestDispatcherTracer) {
                ServiceManagerFactory.getServiceManager().getThreadService().noticeRequestThread(this.transactionData.getThreadId());
            } else {
                ServiceManagerFactory.getServiceManager().getThreadService().noticeBackgroundThread(this.transactionData.getThreadId());
            }
            if (this.transactionData.getRootTracer() instanceof DispatcherTracer) {
                for (TransactionListener listener : TransactionService.this.transactionListeners) {
                    listener.dispatcherTransactionFinished(this.transactionData);
                }
            } else if (Agent.isDebugEnabled()) {
                TransactionService.this.getLogger().finer("Skipping transaction trace for " + this.transactionData);
            }
        }

        private void recordMetrics() {
            StatsEngine statsEngine = this.rpmService.getStatsEngine();
            try {
                for (Tracer tracer : this.transactionData.getTracers()) {
                    tracer.recordMetrics(statsEngine, this.transactionData);
                }
            }
            catch (Throwable t) {
                TransactionService.this.getLogger().severe("An error occurred recording transaction metrics: " + t.getMessage());
                TransactionService.this.getLogger().log(Level.FINER, t.getMessage(), t);
            }
        }
    }
}

