/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.config;

import com.newrelic.agent.Agent;
import com.newrelic.agent.config.AgentConfig;
import com.newrelic.agent.config.AgentConfigChangeListener;
import com.newrelic.agent.config.ConfigService;
import com.newrelic.agent.service.AbstractService;
import com.newrelic.agent.util.DefaultThreadFactory;
import java.io.File;
import java.text.MessageFormat;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.LogManager;

public class ConfigServiceImpl
extends AbstractService
implements ConfigService {
    private static final String CONFIG_THREAD_NAME = "New Relic Config Service";
    private static final long INITIAL_DELAY_IN_SECONDS = 120L;
    private static final long SUBSEQUENT_DELAY_IN_SECONDS = 60L;
    private volatile ScheduledExecutorService scheduledExecutor;
    private final List<AgentConfigChangeListener> listeners = new CopyOnWriteArrayList<AgentConfigChangeListener>();
    private volatile AgentConfig config;
    private final File configFile;
    private long lastModified;

    protected ConfigServiceImpl(AgentConfig config, File configFile) {
        super(ConfigService.class.getSimpleName());
        this.config = config;
        this.configFile = configFile;
    }

    private ScheduledExecutorService createExecutorService() {
        DefaultThreadFactory threadFactory = new DefaultThreadFactory(CONFIG_THREAD_NAME, true);
        return Executors.newSingleThreadScheduledExecutor(threadFactory);
    }

    public boolean isEnabled() {
        return true;
    }

    protected void doStart() {
        if (this.configFile != null) {
            this.lastModified = this.configFile.lastModified();
            String msg = MessageFormat.format("Configuration file is {0}", this.configFile.getAbsolutePath());
            this.getLogger().info(msg);
        }
        this.getLogger().info(MessageFormat.format("java.util.logging.LogManager class is {0}", LogManager.getLogManager().getClass().getName()));
        Object apdex_t = this.config.getProperty("apdex_t", null);
        if (apdex_t != null) {
            this.getLogger().warning("The apdex_t setting is obsolete and is ignored! Set the apdex_t value for an application in RPM");
        }
        this.scheduledExecutor = this.createExecutorService();
        if (this.configFile != null) {
            this.scheduleConfigFileTask();
        }
    }

    private void scheduleConfigFileTask() {
        Runnable runnable = new Runnable(){

            public void run() {
                ConfigServiceImpl.this.checkConfigFile();
            }
        };
        this.scheduledExecutor.scheduleWithFixedDelay(runnable, 120L, 60L, TimeUnit.SECONDS);
    }

    protected void doStop() {
        this.scheduledExecutor.shutdown();
    }

    public void addConfigChangeListener(AgentConfigChangeListener listener) {
        this.listeners.add(listener);
    }

    public void removeConfigChangeListener(AgentConfigChangeListener listener) {
        this.listeners.remove(listener);
    }

    public AgentConfig getAgentConfig() {
        return this.config;
    }

    private void checkConfigFile() {
        if (this.configFile.lastModified() != this.lastModified) {
            Agent.LOG.info("Re-reading New Relic configuration file");
            this.lastModified = this.configFile.lastModified();
            try {
                this.config = new AgentConfig(this.configFile, this.config);
                this.notifyListeners();
            }
            catch (Exception e) {
                Agent.LOG.log(Level.SEVERE, "An error occurred reading the New Relic configuration: {0}", e.toString());
            }
        }
    }

    private void notifyListeners() {
        for (AgentConfigChangeListener listener : this.listeners) {
            listener.configChanged(this.config);
        }
    }
}

