/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.config;

import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Hostname {
    private Hostname() {
    }

    public static String getHostname() {
        Logger log = Logger.getAnonymousLogger();
        log.setLevel(Level.OFF);
        return Hostname.getHostname(log);
    }

    public static String getHostname(Logger log) {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            String osName = ManagementFactory.getOperatingSystemMXBean().getName();
            String msg = "";
            if ("Linux".equals(osName) || "Mac OS X".equals(osName)) {
                msg = "  You might need to add a host entry for this machine in /etc/hosts";
            }
            log.log(Level.FINE, "Error getting host name", e);
            try {
                for (NetworkInterface networkInterface : Collections.list(NetworkInterface.getNetworkInterfaces())) {
                    List<InterfaceAddress> addresses;
                    if (!networkInterface.getName().startsWith("eth") && !networkInterface.getName().startsWith("en") || (addresses = networkInterface.getInterfaceAddresses()).size() <= 0) continue;
                    log.severe("Unable to obtain a host name for this JVM.  Using IP address." + msg);
                    return addresses.iterator().next().getAddress().getHostAddress();
                }
            }
            catch (SocketException e1) {
                // empty catch block
            }
            log.severe("Unable to obtain a host name for this JVM, defaulting to localhost." + msg);
            return "localhost";
        }
    }
}

