/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.database;

import com.newrelic.agent.Agent;
import com.newrelic.agent.AgentMessage;
import com.newrelic.agent.config.AgentConfig;
import com.newrelic.agent.database.DatabaseStatementParser;
import com.newrelic.agent.database.ParsedDatabaseStatement;
import com.newrelic.agent.service.ServiceManagerFactory;
import com.newrelic.agent.util.Strings;
import java.sql.ResultSetMetaData;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DefaultDatabaseStatementParser
implements DatabaseStatementParser {
    private final List<StatementFactory> statementFactories;
    private static final int PATTERN_SWITCHES = 34;
    private static final Pattern COMMENT_PATTERN = Pattern.compile("/\\*.*?\\*/", 32);
    private static final Pattern VALID_METRIC_NAME_MATCHER = Pattern.compile("[a-zA-z0-9.\\$]*");
    private static final Pattern FROM_MATCHER = Pattern.compile("\\s+from\\s+", 34);
    private final boolean reportSqlParserErrors;

    public DefaultDatabaseStatementParser(AgentConfig agentConfig) {
        this.reportSqlParserErrors = agentConfig.isReportSqlParserErrors();
        this.statementFactories = Arrays.asList(new DefaultStatementFactory("select", Pattern.compile("^\\s*select.*?from\\s+([^\\s,(;]*).*", 34), true), new DefaultStatementFactory("show", Pattern.compile("^\\s*show\\s+(.*)$", 34), false){

            protected boolean isValidModelName(String name) {
                return true;
            }
        }, new DefaultStatementFactory("insert", Pattern.compile("^\\s*insert(?:\\s+ignore)?\\s+into\\s+([^\\s(,;]*).*", 34), true), new DefaultStatementFactory("update", Pattern.compile("^\\s*update\\s+([^\\s,;]*).*", 34), true), new DefaultStatementFactory("delete", Pattern.compile("^\\s*delete\\s+from\\s+([^\\s,(;]*).*", 34), true), new DDLStatementFactory("create", Pattern.compile("^\\s*create\\s+procedure.*", 34), "Procedure"), new SelectVariableStatementFactory(), new DDLStatementFactory("drop", Pattern.compile("^\\s*drop\\s+procedure.*", 34), "Procedure"), new DDLStatementFactory("create", Pattern.compile("^\\s*create\\s+table.*", 34), "Table"), new DDLStatementFactory("drop", Pattern.compile("^\\s*drop\\s+table.*", 34), "Table"), new DefaultStatementFactory("alter", Pattern.compile("^\\s*alter\\s+([^\\s]*).*", 34), false), new DefaultStatementFactory("call", Pattern.compile(".*call\\s+([^\\s(,]*).*", 34), true), new DefaultStatementFactory("set", Pattern.compile("^\\s*set\\s+(.*)\\s+as.*", 34), false));
    }

    public ParsedDatabaseStatement getParsedDatabaseStatement(String statement, ResultSetMetaData metaData) {
        if (metaData != null) {
            try {
                String tableName;
                int columnCount = metaData.getColumnCount();
                if (columnCount > 0 && !Strings.isEmpty(tableName = metaData.getTableName(1))) {
                    return new ParsedDatabaseStatement(tableName.toLowerCase(), "select", true);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.parseStatement(statement);
    }

    ParsedDatabaseStatement parseStatement(String statement) {
        try {
            statement = COMMENT_PATTERN.matcher(statement).replaceAll("");
            for (StatementFactory factory : this.statementFactories) {
                ParsedDatabaseStatement parsedStatement = factory.parseStatement(statement);
                if (parsedStatement == null) continue;
                return parsedStatement;
            }
            return null;
        }
        catch (Throwable t) {
            Agent.LOG.log(Level.FINE, "Unable to parse sql \"{0}\" - {1}", new Object[]{statement, t.toString()});
            Agent.LOG.log(Level.FINER, "SQL parsing error", t);
            return null;
        }
    }

    static boolean isValidName(String string) {
        return VALID_METRIC_NAME_MATCHER.matcher(string).matches();
    }

    private class DDLStatementFactory
    extends DefaultStatementFactory {
        private final String type;

        public DDLStatementFactory(String key, Pattern pattern, String type) {
            super(key, pattern, false);
            this.type = type;
        }

        ParsedDatabaseStatement createParsedDatabaseStatement(String model) {
            return new ParsedDatabaseStatement(this.type, this.key, this.isMetricGenerator());
        }
    }

    private class SelectVariableStatementFactory
    implements StatementFactory {
        private final ParsedDatabaseStatement innerSelectStatement = new ParsedDatabaseStatement("INNER_SELECT", "select", false);
        private final ParsedDatabaseStatement statement = new ParsedDatabaseStatement("VARIABLE", "select", false);
        private final Pattern pattern = Pattern.compile(".*select\\s+([^\\s,]*).*", 34);

        private SelectVariableStatementFactory() {
        }

        public ParsedDatabaseStatement parseStatement(String statement) {
            Matcher matcher = this.pattern.matcher(statement);
            if (matcher.matches()) {
                if (FROM_MATCHER.matcher(statement).find()) {
                    return this.innerSelectStatement;
                }
                return this.statement;
            }
            return null;
        }
    }

    class DefaultStatementFactory
    implements StatementFactory {
        private final Pattern pattern;
        protected final String key;
        private final boolean generateMetric;

        public DefaultStatementFactory(String key, Pattern pattern, boolean generateMetric) {
            this.key = key;
            this.pattern = pattern;
            this.generateMetric = generateMetric;
        }

        protected boolean isMetricGenerator() {
            return this.generateMetric;
        }

        public ParsedDatabaseStatement parseStatement(String statement) {
            Matcher matcher = this.pattern.matcher(statement);
            if (matcher.matches()) {
                String model;
                String string = model = matcher.groupCount() > 0 ? matcher.group(1) : "unknown";
                if (model.length() == 0) {
                    ServiceManagerFactory.getServiceManager().getRPMServiceManager().getRPMService().logAndQueueMessages(Level.FINE, new AgentMessage(MessageFormat.format("Parsed an empty model name for {0} statement : {1}", this.key, statement)));
                    return null;
                }
                if (!this.isValidModelName(model = Strings.unquoteDatabaseName(model))) {
                    if (DefaultDatabaseStatementParser.this.reportSqlParserErrors) {
                        ServiceManagerFactory.getServiceManager().getRPMServiceManager().getRPMService().logAndQueueMessages(Level.FINE, new AgentMessage(MessageFormat.format("Parsed an invalid model name {0} for {1} statement : {2}", model, this.key, statement)));
                    }
                    model = "ParseError";
                }
                return this.createParsedDatabaseStatement(model);
            }
            return null;
        }

        protected boolean isValidModelName(String name) {
            return DefaultDatabaseStatementParser.isValidName(name);
        }

        ParsedDatabaseStatement createParsedDatabaseStatement(String model) {
            return new ParsedDatabaseStatement(model.toLowerCase(), this.key, this.generateMetric);
        }
    }

    private static interface StatementFactory {
        public ParsedDatabaseStatement parseStatement(String var1);
    }
}

