/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.database;

import com.newrelic.agent.Agent;
import com.newrelic.agent.config.AgentConfig;
import com.newrelic.agent.config.TransactionTracerConfig;
import com.newrelic.agent.service.ServiceManager;
import com.newrelic.agent.service.ServiceManagerFactory;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SqlObfuscator {
    public static final String OBFUSCATED_SETTING = "obfuscated";
    public static final String RAW_SETTING = "raw";
    public static final String OFF_SETTING = "off";
    private static volatile SqlObfuscator INSTANCE;

    SqlObfuscator() {
    }

    public abstract String obfuscateSql(String var1);

    public boolean isObfuscating() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SqlObfuscator getInstance() {
        if (INSTANCE != null) return INSTANCE;
        Class<SqlObfuscator> clazz = SqlObfuscator.class;
        synchronized (SqlObfuscator.class) {
            if (INSTANCE != null) return INSTANCE;
            ServiceManager serviceManager = ServiceManagerFactory.getServiceManager();
            AgentConfig config = serviceManager.getConfigService().getAgentConfig();
            String recordSql = config.getTransactionTracerConfig().getRecordSql();
            INSTANCE = SqlObfuscator.getSqlObfuscator(config, recordSql);
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    protected static SqlObfuscator getSqlObfuscator(AgentConfig config, String recordSqlValue) {
        TransactionTracerConfig transactionTracerConfig = config.getTransactionTracerConfig();
        if (!transactionTracerConfig.isEnabled()) {
            return SqlObfuscator.getNoSqlObfuscator();
        }
        if (recordSqlValue == null) {
            return SqlObfuscator.getDefaultSqlObfuscator();
        }
        if (OFF_SETTING.equals(recordSqlValue = recordSqlValue.trim().toLowerCase()) || "false".equals(recordSqlValue)) {
            return SqlObfuscator.getNoSqlObfuscator();
        }
        if (RAW_SETTING.equals(recordSqlValue)) {
            if (transactionTracerConfig.isLogSql()) {
                Agent.LOG.warning("Agent is configured to log raw SQL");
            } else {
                Agent.LOG.warning("Agent is configured to send raw SQL to RPM service");
            }
            List<String> obfuscatedSqlFields = transactionTracerConfig.getObfuscatedSqlFields();
            if (obfuscatedSqlFields.isEmpty()) {
                return SqlObfuscator.getNoObfuscationSqlObfuscator();
            }
            return SqlObfuscator.getObfuscateFieldsSqlObfuscator(obfuscatedSqlFields);
        }
        if (OBFUSCATED_SETTING.equals(recordSqlValue)) {
            if (transactionTracerConfig.isLogSql()) {
                Agent.LOG.info("Agent is configured to log obfuscated SQL");
            } else {
                Agent.LOG.info("Agent is configured to send obfuscated SQL to RPM service");
            }
            return SqlObfuscator.getDefaultSqlObfuscator();
        }
        Agent.LOG.log(Level.SEVERE, "Unknown value \"{0}\" for transaction_tracer:record_sql", recordSqlValue);
        return SqlObfuscator.getDefaultSqlObfuscator();
    }

    public static SqlObfuscator getDefaultSqlObfuscator() {
        return new DefaultSqlObfuscator();
    }

    private static SqlObfuscator getObfuscateFieldsSqlObfuscator(List<String> obfuscatedSqlFields) {
        return new FieldsSqlObfuscator(obfuscatedSqlFields);
    }

    private static SqlObfuscator getNoObfuscationSqlObfuscator() {
        return new SqlObfuscator(){

            public String obfuscateSql(String sql) {
                return sql;
            }
        };
    }

    private static SqlObfuscator getNoSqlObfuscator() {
        return new SqlObfuscator(){

            public String obfuscateSql(String sql) {
                return null;
            }
        };
    }

    public static SqlObfuscator getCachingSqlObfuscator(SqlObfuscator sqlObfuscator) {
        if (sqlObfuscator.isObfuscating()) {
            return new CachingSqlObfuscator(sqlObfuscator);
        }
        return sqlObfuscator;
    }

    static class CachingSqlObfuscator
    extends SqlObfuscator {
        private final Map<String, String> cache = new HashMap<String, String>();
        private final SqlObfuscator sqlObfuscator;

        public CachingSqlObfuscator(SqlObfuscator sqlObfuscator) {
            this.sqlObfuscator = sqlObfuscator;
        }

        public String obfuscateSql(String sql) {
            String obfuscatedSql = this.cache.get(sql);
            if (obfuscatedSql == null) {
                obfuscatedSql = this.sqlObfuscator.obfuscateSql(sql);
                this.cache.put(sql, obfuscatedSql);
            }
            return obfuscatedSql;
        }

        public boolean isObfuscating() {
            return this.sqlObfuscator.isObfuscating();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FieldsSqlObfuscator
    extends SqlObfuscator {
        private static final Pattern INSERT_INTO_VALUES_PATTERN = Pattern.compile("(\\s*insert\\s+into\\s+\\w*\\s+\\()(.*)(\\)\\s+values\\s+\\()(.*)(\\).*)", 2);
        private static final int INSERT_INTO_VALUES_COLUMNS_GROUP = 2;
        private static final int INSERT_INTO_VALUES_VALUES_GROUP = 4;
        private static final Pattern INSERT_INTO_VALUES_NO_COLUMNS_PATTERN = Pattern.compile("(\\s*insert\\s+into\\s+\\w*\\s+values\\s+\\()(.*)(\\).*)", 2);
        private static final int INSERT_INTO_VALUES_NO_COLUMNS_VALUES_GROUP = 2;
        private static final Pattern WHERE_IN_PATTERN = Pattern.compile("(\\swhere\\s+([^\\s]*)\\s+in\\s+\\()([^\\)]*)(\\))", 2);
        private static final int WHERE_IN_COL_GROUP = 2;
        private static final int WHERE_IN_VALUES_GROUP = 3;
        private static final Pattern CALLED_PROCEDURE_PATTERN = Pattern.compile("(call\\s+([^\\s]*)\\s*\\()([^\\)]*)(\\))", 2);
        private static final int CALLED_PROCEDURE_VALUES_GROUP = 3;
        private static final Pattern CSV_PATTERN = Pattern.compile("(\\s*)('[^']*'|\"[^\"]*\"|[^,\\s]+)(\\s*,?)");
        private static final int CSV_VALUE_GROUP = 2;
        private final Pattern sqlFieldsToObfuscatePattern;
        private final Pattern fieldSingleQuotesPattern;
        private final Pattern fieldDoubleQuotesPattern;
        private final Pattern fieldNoQuotesPattern;
        private static final String SINGLE_OR_DOUBLE_QUOTE_REPLACEMENT = "$1?";
        private static final String NO_QUOTE_REPLACEMENT = "$1$5?";

        public FieldsSqlObfuscator(List<String> obfuscatedSqlFields) {
            StringBuilder sb = new StringBuilder();
            boolean first = true;
            for (String sqlField : obfuscatedSqlFields) {
                if (first) {
                    first = false;
                } else {
                    sb.append("|");
                }
                sb.append(sqlField);
            }
            String sqlFieldsToObfuscateRegex = sb.toString();
            String pattern = "^(" + sqlFieldsToObfuscateRegex + ")$";
            this.sqlFieldsToObfuscatePattern = Pattern.compile(pattern, 2);
            sb = new StringBuilder();
            sb.append("(");
            sb.append("(");
            sb.append(sqlFieldsToObfuscateRegex);
            sb.append(")");
            sb.append("[\\s)]*=[^=']*)('[^']*')");
            this.fieldSingleQuotesPattern = Pattern.compile(sb.toString(), 2);
            sb = new StringBuilder();
            sb.append("(");
            sb.append("(");
            sb.append(sqlFieldsToObfuscateRegex);
            sb.append(")");
            sb.append("[\\s)]*=[^=\"]*)(\"[^\"]*\")");
            this.fieldDoubleQuotesPattern = Pattern.compile(sb.toString(), 2);
            sb = new StringBuilder();
            sb.append("(");
            sb.append("(");
            sb.append(sqlFieldsToObfuscateRegex);
            sb.append(")");
            sb.append("[\\s)]*=)((\\d+)|([^=]*[(\\s,])(\\d+))");
            this.fieldNoQuotesPattern = Pattern.compile(sb.toString(), 2);
        }

        @Override
        public String obfuscateSql(String sql) {
            String obfuscatedSql = this.obfuscateInsertIntoValues(sql);
            if (obfuscatedSql != null) {
                return obfuscatedSql;
            }
            obfuscatedSql = this.obfuscateInsertIntoValuesNoColumns(sql);
            if (obfuscatedSql != null) {
                return obfuscatedSql;
            }
            obfuscatedSql = this.obfuscateCallableStatement(sql);
            if (obfuscatedSql != null) {
                return obfuscatedSql;
            }
            obfuscatedSql = this.obfuscateWhereIn(sql);
            return this.obfuscateLiteralEqualityComparison(obfuscatedSql);
        }

        private String obfuscateLiteralEqualityComparison(String sql) {
            String obfuscatedSql = this.obfuscateLiteral(this.fieldSingleQuotesPattern, sql, SINGLE_OR_DOUBLE_QUOTE_REPLACEMENT);
            obfuscatedSql = this.obfuscateLiteral(this.fieldDoubleQuotesPattern, obfuscatedSql, SINGLE_OR_DOUBLE_QUOTE_REPLACEMENT);
            return this.obfuscateLiteral(this.fieldNoQuotesPattern, obfuscatedSql, NO_QUOTE_REPLACEMENT);
        }

        private String obfuscateLiteral(Pattern pattern, String sql, String replacement) {
            StringBuffer obfuscatedSql = null;
            Matcher obfuscationMatcher = pattern.matcher(sql);
            boolean found = false;
            while (obfuscationMatcher.find()) {
                if (!found) {
                    obfuscatedSql = new StringBuffer();
                    found = true;
                }
                obfuscationMatcher.appendReplacement(obfuscatedSql, replacement);
            }
            if (!found) {
                return sql;
            }
            obfuscationMatcher.appendTail(obfuscatedSql);
            return obfuscatedSql.toString();
        }

        private String obfuscateInsertIntoValues(String sql) {
            Matcher insertIntoValuesMatcher = INSERT_INTO_VALUES_PATTERN.matcher(sql);
            if (!insertIntoValuesMatcher.matches()) {
                return null;
            }
            StringBuffer obfuscatedSql = new StringBuffer();
            String cols = insertIntoValuesMatcher.group(2);
            String values = insertIntoValuesMatcher.group(4);
            StringBuffer valuesSql = new StringBuffer();
            Matcher colsMatcher = CSV_PATTERN.matcher(cols);
            Matcher valuesMatcher = CSV_PATTERN.matcher(values);
            while (colsMatcher.find() && valuesMatcher.find()) {
                String field = colsMatcher.group(2);
                if (this.sqlFieldsToObfuscatePattern.matcher(field).find()) {
                    valuesMatcher.appendReplacement(valuesSql, "$1?$3");
                    continue;
                }
                valuesMatcher.appendReplacement(valuesSql, valuesMatcher.group());
            }
            String replacementString = "$1$2$3" + valuesSql.toString() + "$5";
            insertIntoValuesMatcher.appendReplacement(obfuscatedSql, replacementString);
            return obfuscatedSql.toString();
        }

        private String obfuscateInsertIntoValuesNoColumns(String sql) {
            Matcher insertIntoValuesMatcher = INSERT_INTO_VALUES_NO_COLUMNS_PATTERN.matcher(sql);
            if (!insertIntoValuesMatcher.matches()) {
                return null;
            }
            StringBuffer obfuscatedSql = new StringBuffer();
            String values = insertIntoValuesMatcher.group(2);
            StringBuffer valuesSql = new StringBuffer();
            Matcher valuesMatcher = CSV_PATTERN.matcher(values);
            while (valuesMatcher.find()) {
                valuesMatcher.appendReplacement(valuesSql, "$1?$3");
            }
            String replacementString = "$1" + valuesSql.toString() + "$3";
            insertIntoValuesMatcher.appendReplacement(obfuscatedSql, replacementString);
            return obfuscatedSql.toString();
        }

        private String obfuscateWhereIn(String sql) {
            Matcher whereInMatcher = WHERE_IN_PATTERN.matcher(sql);
            if (!whereInMatcher.find()) {
                return sql;
            }
            whereInMatcher.reset();
            StringBuffer obfuscatedSql = new StringBuffer();
            while (whereInMatcher.find()) {
                String field = whereInMatcher.group(2);
                Matcher fieldMatcher = this.sqlFieldsToObfuscatePattern.matcher(field);
                if (!fieldMatcher.find()) {
                    whereInMatcher.appendReplacement(obfuscatedSql, whereInMatcher.group());
                    continue;
                }
                String values = whereInMatcher.group(3);
                StringBuffer valuesSql = new StringBuffer();
                Matcher valuesMatcher = CSV_PATTERN.matcher(values);
                while (valuesMatcher.find()) {
                    valuesMatcher.appendReplacement(valuesSql, "$1?$3");
                }
                String replacementString = "$1" + valuesSql.toString() + "$4";
                whereInMatcher.appendReplacement(obfuscatedSql, replacementString);
            }
            whereInMatcher.appendTail(obfuscatedSql);
            return obfuscatedSql.toString();
        }

        private String obfuscateCallableStatement(String sql) {
            Matcher callableMatcher = CALLED_PROCEDURE_PATTERN.matcher(sql);
            if (!callableMatcher.find()) {
                return null;
            }
            StringBuffer obfuscatedSql = new StringBuffer();
            String values = callableMatcher.group(3);
            StringBuffer valuesSql = new StringBuffer();
            Matcher valuesMatcher = CSV_PATTERN.matcher(values);
            while (valuesMatcher.find()) {
                valuesMatcher.appendReplacement(valuesSql, "$1?$3");
            }
            String replacementString = "$1" + valuesSql.toString() + "$4";
            callableMatcher.appendReplacement(obfuscatedSql, replacementString);
            return obfuscatedSql.toString();
        }

        @Override
        public boolean isObfuscating() {
            return true;
        }
    }

    private static class DefaultSqlObfuscator
    extends SqlObfuscator {
        protected static final Pattern[] OBFUSCATION_PATTERNS = new Pattern[]{Pattern.compile("'(.*?[^\\'])??'(?!')"), Pattern.compile("\"(.*?[^\\\"])??\"(?!\")"), Pattern.compile("\\d+")};

        private DefaultSqlObfuscator() {
        }

        public String obfuscateSql(String sql) {
            if (sql == null || sql.length() == 0) {
                return sql;
            }
            for (Pattern pattern : OBFUSCATION_PATTERNS) {
                sql = pattern.matcher(sql).replaceAll("?");
            }
            return sql;
        }

        public boolean isObfuscating() {
            return true;
        }
    }
}

