/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.deadlock;

import com.newrelic.agent.InstrumentationProxy;
import com.newrelic.agent.deadlock.AbstractDeadLockDetector;
import com.newrelic.agent.deadlock.DeadLockDetector5;
import com.newrelic.agent.deadlock.DeadLockDetector6;
import com.newrelic.agent.service.AbstractService;
import com.newrelic.agent.service.ServiceManagerFactory;
import com.newrelic.agent.util.DefaultThreadFactory;
import java.text.MessageFormat;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;

public class DeadlockDetectorService
extends AbstractService {
    private static final String DEADLOCK_DETECTOR_THREAD_NAME = "New Relic Deadlock Detector";
    private static final long INITIAL_DELAY_IN_SECONDS = 300L;
    private static final long SUBSEQUENT_DELAY_IN_SECONDS = 300L;
    private final ScheduledExecutorService scheduledExecutor;
    private volatile ScheduledFuture<?> deadlockTask;

    public DeadlockDetectorService() {
        super(DeadlockDetectorService.class.getSimpleName());
        DefaultThreadFactory threadFactory = new DefaultThreadFactory(DEADLOCK_DETECTOR_THREAD_NAME, true);
        this.scheduledExecutor = Executors.newSingleThreadScheduledExecutor(threadFactory);
    }

    protected void doStart() {
        final AbstractDeadLockDetector deadlockDetector = this.getDeadlockDetector();
        Runnable runnable = new Runnable(){

            public void run() {
                try {
                    deadlockDetector.detectDeadlockedThreads();
                }
                catch (Throwable t) {
                    if (DeadlockDetectorService.this.getLogger().isLoggable(Level.FINER)) {
                        DeadlockDetectorService.this.getLogger().log(Level.FINER, MessageFormat.format("Failed to detect deadlocked threads: {0}", t), t);
                    }
                    DeadlockDetectorService.this.getLogger().severe(MessageFormat.format("Failed to detect deadlocked threads: {0}", t));
                }
            }
        };
        this.deadlockTask = this.scheduledExecutor.scheduleWithFixedDelay(runnable, 300L, 300L, TimeUnit.SECONDS);
    }

    protected void doStop() {
        if (this.deadlockTask != null) {
            this.deadlockTask.cancel(false);
        }
    }

    public boolean isEnabled() {
        return true;
    }

    private AbstractDeadLockDetector getDeadlockDetector() {
        InstrumentationProxy instrumentation = ServiceManagerFactory.getServiceManager().getAgent().getInstrumentation();
        if (instrumentation == null) {
            return new DeadLockDetector5();
        }
        return this.getDeadlockDetector(instrumentation.getMinorJVMVersion());
    }

    private AbstractDeadLockDetector getDeadlockDetector(int minorJvmVersion) {
        return minorJvmVersion > 5 ? new DeadLockDetector6() : new DeadLockDetector5();
    }
}

