/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.extension;

import com.newrelic.agent.Agent;
import com.newrelic.agent.config.Config;
import java.util.Map;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Extension {
    private final String name;
    private final Config configuration;
    private boolean enabled;

    Extension(String name, Map<?, ?> configuration) throws IllegalArgumentException {
        if (name == null) {
            throw new IllegalArgumentException("Extensions must have a name");
        }
        this.name = name;
        this.configuration = new Config(configuration);
        this.enabled = this.configuration.getProperty("enabled", true);
    }

    Extension(Map<?, ?> config) {
        this((String)config.get("name"), config);
    }

    public final String getName() {
        return this.name;
    }

    public String toString() {
        return this.getName() + " Extension";
    }

    public final Config getConfiguration() {
        return this.configuration;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public String getVersion() {
        return this.configuration.getProperty("version", "n/a");
    }

    public double getVersionNumber() {
        try {
            return this.configuration.getProperty("version", 0.0);
        }
        catch (Exception e) {
            Agent.LOG.log(Level.SEVERE, "Extension \"{0}\" has an invalid version \"{1}\"", new Object[]{this.getName(), this.getVersion()});
            return 0.0;
        }
    }
}

