/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation;

import com.newrelic.agent.InstrumentationProxy;
import com.newrelic.agent.instrumentation.StartableClassFileTransformer;
import com.newrelic.org.objectweb.asm.ClassReader;
import com.newrelic.org.objectweb.asm.ClassVisitor;
import com.newrelic.org.objectweb.asm.ClassWriter;
import java.lang.instrument.IllegalClassFormatException;
import java.security.ProtectionDomain;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractClassTransformer
implements StartableClassFileTransformer {
    private final int classreaderFlags;
    private final boolean enabled;

    public AbstractClassTransformer(int classreaderFlags) {
        this(classreaderFlags, true);
    }

    public AbstractClassTransformer(int classreaderFlags, boolean enabled) {
        this.enabled = enabled;
        this.classreaderFlags = classreaderFlags;
    }

    @Override
    public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
        try {
            if (!this.matches(loader, className, classBeingRedefined, protectionDomain, classfileBuffer)) {
                return null;
            }
            ClassReader cr = new ClassReader(classfileBuffer);
            ClassWriter cw = new ClassWriter(cr, 1);
            cr.accept(this.getClassVisitor(cr, cw, className), this.classreaderFlags);
            return cw.toByteArray();
        }
        catch (Throwable t) {
            return null;
        }
    }

    @Override
    public void start(InstrumentationProxy instrumentation, boolean isRetransformSupported) {
        boolean canRetransform;
        boolean bl = canRetransform = isRetransformSupported && this.isRetransformSupported();
        if (this.isEnabled()) {
            instrumentation.addTransformer(this, canRetransform);
            this.start();
        }
    }

    protected void start() {
    }

    protected boolean isEnabled() {
        return this.enabled;
    }

    protected abstract boolean isRetransformSupported();

    protected abstract ClassVisitor getClassVisitor(ClassReader var1, ClassWriter var2, String var3);

    protected abstract boolean matches(ClassLoader var1, String var2, Class<?> var3, ProtectionDomain var4, byte[] var5);
}

