/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation;

import com.newrelic.agent.Agent;
import com.newrelic.agent.instrumentation.AbstractClassTransformer;
import com.newrelic.agent.instrumentation.AgentWrapper;
import com.newrelic.agent.instrumentation.ClassTransformer;
import com.newrelic.org.objectweb.asm.ClassAdapter;
import com.newrelic.org.objectweb.asm.ClassReader;
import com.newrelic.org.objectweb.asm.ClassVisitor;
import com.newrelic.org.objectweb.asm.ClassWriter;
import com.newrelic.org.objectweb.asm.MethodVisitor;
import com.newrelic.org.objectweb.asm.Type;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.security.ProtectionDomain;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class AgentHandleClassTransformer
extends AbstractClassTransformer {
    static final String OBJECT_FIELD_NAME = "nextUniqueNumberLock";
    static final String AGENT_HANDLE_CLASS_NAME = "java.lang.reflect.Proxy";
    static final String AGENT_HANDLE_INTERNAL_CLASS_NAME = "java.lang.reflect.Proxy".replace('.', '/');
    static final String GET_AGENT_HANDLE_METHOD_NAME = "getAgentHandle";
    static final String GET_AGENT_HANDLE_METHOD_DESC = "()L" + Type.getInternalName(InvocationHandler.class) + ";";
    static final String AGENT_HANDLE_FIELD_TYPE = Type.getInternalName(InvocationHandler.class);
    private ClassTransformer classTransformer;

    public AgentHandleClassTransformer(ClassTransformer classTransformer) {
        super(classTransformer.getClassReaderFlags());
        this.classTransformer = classTransformer;
    }

    @Override
    protected boolean isRetransformSupported() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ClassVisitor getClassVisitor(ClassReader cr, ClassWriter cw, String className) {
        try {
            AgentHandleClassAdapter agentHandleClassAdapter = new AgentHandleClassAdapter(cw);
            return agentHandleClassAdapter;
        }
        finally {
            this.classTransformer.getInstrumentation().removeTransformer(this);
        }
    }

    @Override
    protected boolean matches(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) {
        return AGENT_HANDLE_INTERNAL_CLASS_NAME.equals(className);
    }

    @Override
    protected void start() {
        Class<?> magicClass;
        try {
            magicClass = Class.forName(AGENT_HANDLE_CLASS_NAME);
            Field proxyClassesField = magicClass.getDeclaredField(OBJECT_FIELD_NAME);
            proxyClassesField.setAccessible(true);
            proxyClassesField.set(magicClass, AgentWrapper.getAgentWrapper());
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to initialize the agent handle", e);
        }
        boolean handleExists = false;
        try {
            magicClass.getMethod(GET_AGENT_HANDLE_METHOD_NAME, new Class[0]);
            handleExists = true;
        }
        catch (NoSuchMethodException nme) {
            Agent.LOG.warning("The getAgentHandle is missing from Proxy");
            try {
                if (this.classTransformer.getInstrumentation().isRetransformClassesSupported()) {
                    this.classTransformer.getInstrumentation().retransformClasses(Proxy.class);
                }
            }
            catch (Exception e) {
                Agent.LOG.warning("Unable to retransform the Proxy class : " + e);
            }
        }
        catch (Exception e) {
            Agent.LOG.warning("An exception was thrown checking Proxy.getAgentHandle() : " + e);
        }
        this.classTransformer.setAgentHandleExists(handleExists);
    }

    class AgentHandleClassAdapter
    extends ClassAdapter {
        public AgentHandleClassAdapter(ClassVisitor cv) {
            super(cv);
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            super.visit(version, access, name, signature, superName, interfaces);
            MethodVisitor mv = this.cv.visitMethod(9, AgentHandleClassTransformer.GET_AGENT_HANDLE_METHOD_NAME, GET_AGENT_HANDLE_METHOD_DESC, null, null);
            mv.visitCode();
            mv.visitFieldInsn(178, AGENT_HANDLE_INTERNAL_CLASS_NAME, AgentHandleClassTransformer.OBJECT_FIELD_NAME, "Ljava/lang/Object;");
            mv.visitInsn(176);
            mv.visitMaxs(2, 0);
            mv.visitEnd();
        }
    }
}

