/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation;

import java.text.MessageFormat;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;
import java.util.regex.Pattern;

public class ClassNameFilter {
    private final List<Pattern> excludePatterns = new LinkedList<Pattern>();
    private final List<Pattern> includePatterns = new LinkedList<Pattern>();
    private final Logger logger;

    public ClassNameFilter(Logger logger) {
        this.logger = logger;
    }

    public boolean isExcluded(String className) {
        for (Pattern pattern : this.excludePatterns) {
            if (!pattern.matcher(className).matches()) continue;
            return true;
        }
        return false;
    }

    public boolean isIncluded(String className) {
        for (Pattern pattern : this.includePatterns) {
            if (!pattern.matcher(className).matches()) continue;
            return true;
        }
        return false;
    }

    public void addInclude(String include) {
        if (this.isRegex(include)) {
            this.addIncludeRegex(include);
        } else {
            this.addIncludeClass(include);
        }
    }

    public void addIncludeClass(String className) {
        String regex = this.classNameToRegex(className);
        this.addIncludeRegex(regex);
    }

    public void addIncludeRegex(String regex) {
        Pattern pattern = this.regexToPattern(regex);
        if (pattern != null) {
            this.includePatterns.add(pattern);
        }
    }

    public void addExclude(String exclude) {
        if (this.isRegex(exclude)) {
            this.addExcludeRegex(exclude);
        } else {
            this.addExcludeClass(exclude);
        }
    }

    public void addExcludeClass(String className) {
        String regex = this.classNameToRegex(className);
        this.addExcludeRegex(regex);
    }

    public void addExcludeRegex(String regex) {
        Pattern pattern = this.regexToPattern(regex);
        if (pattern != null) {
            this.excludePatterns.add(pattern);
        }
    }

    private String classNameToRegex(String className) {
        return "^" + className.replace("$", "\\$") + "$";
    }

    private Pattern regexToPattern(String regex) {
        try {
            return Pattern.compile(regex);
        }
        catch (Exception e) {
            this.logger.severe(MessageFormat.format("Unable to compile pattern: {0}", regex));
            return null;
        }
    }

    private boolean isRegex(String value) {
        return value.indexOf(42) >= 0 || value.indexOf(124) >= 0 || value.indexOf(94) >= 0;
    }
}

