/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation;

import com.newrelic.agent.InstrumentationProxy;
import com.newrelic.agent.config.AgentConfig;
import com.newrelic.agent.instrumentation.AgentHandleClassTransformer;
import com.newrelic.agent.instrumentation.ClassLoaderClassTransformer;
import com.newrelic.agent.instrumentation.ClassTransformer;
import com.newrelic.agent.instrumentation.ClassTransformerService;
import com.newrelic.agent.instrumentation.JDBCClassTransformer;
import com.newrelic.agent.instrumentation.StartableClassFileTransformer;
import com.newrelic.agent.service.AbstractService;
import com.newrelic.agent.service.ServiceManagerFactory;

public class ClassTransformerServiceImpl
extends AbstractService
implements ClassTransformerService {
    private final boolean enabled;
    private volatile ClassTransformer classTransformer;

    public ClassTransformerServiceImpl() throws Exception {
        super(ClassTransformerServiceImpl.class.getSimpleName());
        AgentConfig config = ServiceManagerFactory.getServiceManager().getConfigService().getAgentConfig();
        this.enabled = config.getClassTransformerConfig().getProperty("enabled", true);
    }

    protected void doStart() throws Exception {
        if (!this.isEnabled()) {
            this.getLogger().info("The class transformer is disabled.  No classes will be instrumented.");
            return;
        }
        InstrumentationProxy instrProxy = ServiceManagerFactory.getServiceManager().getAgent().getInstrumentation();
        if (instrProxy == null) {
            this.getLogger().severe("Unable to initialize the class transformer because there is no instrumentation hook");
        } else {
            this.classTransformer = this.startClassTransformer(instrProxy);
        }
    }

    private ClassTransformer startClassTransformer(InstrumentationProxy instrProxy) {
        StartableClassFileTransformer[] classTransformers;
        boolean retransformSupported = this.isRetransformationSupported(instrProxy);
        ClassTransformer classTransformer = new ClassTransformer(instrProxy, retransformSupported);
        for (StartableClassFileTransformer transformer : classTransformers = new StartableClassFileTransformer[]{new AgentHandleClassTransformer(classTransformer), classTransformer, new JDBCClassTransformer(classTransformer), new ClassLoaderClassTransformer(classTransformer.getClassReaderFlags())}) {
            transformer.start(instrProxy, retransformSupported);
        }
        return classTransformer;
    }

    private boolean isRetransformationSupported(InstrumentationProxy instrProxy) {
        AgentConfig config = ServiceManagerFactory.getServiceManager().getConfigService().getAgentConfig();
        Boolean enableRetransform = (Boolean)config.getProperty("enable_class_retransformation");
        if (enableRetransform != null) {
            return enableRetransform;
        }
        return instrProxy.isRetransformClassesSupported();
    }

    protected void doStop() throws Exception {
        if (this.classTransformer != null) {
            this.classTransformer.shutdown();
            InstrumentationProxy instrProxy = ServiceManagerFactory.getServiceManager().getAgent().getInstrumentation();
            if (instrProxy != null) {
                instrProxy.removeTransformer(this.classTransformer);
            }
        }
    }

    public ClassTransformer getClassTransformer() {
        return this.classTransformer;
    }

    public boolean isEnabled() {
        return this.enabled;
    }
}

