/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation;

import com.newrelic.agent.instrumentation.InstrumentedClass;
import com.newrelic.agent.instrumentation.InvocationHandlerTracingMethodAdapter;
import com.newrelic.agent.instrumentation.PointCut;
import com.newrelic.agent.instrumentation.StopProcessingException;
import com.newrelic.agent.instrumentation.classmatchers.AnnotationMatcher;
import com.newrelic.agent.service.ServiceManagerFactory;
import com.newrelic.org.objectweb.asm.AnnotationVisitor;
import com.newrelic.org.objectweb.asm.ClassAdapter;
import com.newrelic.org.objectweb.asm.ClassVisitor;
import com.newrelic.org.objectweb.asm.MethodVisitor;
import com.newrelic.org.objectweb.asm.Type;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class GenericClassAdapter
extends ClassAdapter {
    private int strongMatchCount = 0;
    private int weakMatchCount = 0;
    private final String className;
    private final Collection<PointCut> strongMatchPointCuts;
    private final Collection<PointCut> weakMatchPointCuts;
    private final Set<String> visibleAnnotations;
    private final Class classBeingRedefined;
    private boolean firstMethod = true;
    private final boolean customTracingDisabled = !ServiceManagerFactory.getServiceManager().getConfigService().getAgentConfig().isCustomTracingEnabled();
    private final boolean agentHandleValid;

    public GenericClassAdapter(boolean agentHandleValid, ClassVisitor cv, String className, Class<?> classBeingRedefined, Collection<PointCut> strongMatches, Collection<PointCut> possibleMatches) {
        super(cv);
        this.visibleAnnotations = new HashSet<String>();
        this.className = className;
        this.strongMatchPointCuts = strongMatches;
        this.weakMatchPointCuts = possibleMatches;
        this.classBeingRedefined = classBeingRedefined;
        this.agentHandleValid = agentHandleValid;
    }

    @Override
    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        boolean isInterface;
        super.visit(version, access, name, signature, superName, interfaces);
        boolean bl = isInterface = (access & 0x200) != 0;
        if (isInterface) {
            throw new StopProcessingException(name + " is an interface");
        }
    }

    boolean isAgentHandleValid() {
        return this.agentHandleValid;
    }

    @Override
    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        if (visible) {
            this.visibleAnnotations.add(desc);
        }
        return super.visitAnnotation(desc, visible);
    }

    public boolean isWeakMatch() {
        return this.weakMatchCount > 0;
    }

    public boolean isStrongMatch() {
        return this.strongMatchCount > 0;
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        Collection<PointCut> strong;
        List weak;
        MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
        if ((access & 0x400) != 0) {
            return mv;
        }
        if (this.firstMethod) {
            this.processClassAnnotations();
            this.firstMethod = false;
        }
        Collection<Object> collection = weak = (strong = this.matches(this.strongMatchPointCuts, access, name, desc, signature, exceptions)).isEmpty() ? this.matches(this.weakMatchPointCuts, access, name, desc, signature, exceptions) : Collections.EMPTY_LIST;
        if (strong.isEmpty() && weak.isEmpty() && this.customTracingDisabled) {
            return mv;
        }
        if (!strong.isEmpty()) {
            ++this.strongMatchCount;
        } else if (!weak.isEmpty()) {
            ++this.weakMatchCount;
        }
        return new InvocationHandlerTracingMethodAdapter(this, mv, access, this.className, this.classBeingRedefined, name, desc, strong, weak);
    }

    private void processClassAnnotations() {
        for (PointCut pc : this.weakMatchPointCuts.toArray(new PointCut[0])) {
            if (!(pc.getClassMatcher() instanceof AnnotationMatcher)) continue;
            if (((AnnotationMatcher)((Object)pc.getClassMatcher())).matches(this.visibleAnnotations)) {
                this.strongMatchPointCuts.add(pc);
            }
            this.weakMatchPointCuts.remove(pc);
        }
    }

    void incrementStrongMatchCount() {
        ++this.strongMatchCount;
    }

    private Collection<PointCut> matches(Collection<PointCut> pointcuts, int access, String name, String desc, String signature, String[] exceptions) {
        LinkedList<PointCut> pcs = new LinkedList<PointCut>();
        for (PointCut pc : pointcuts) {
            if (!pc.getMethodMatcher().matches(access, name, desc, signature, exceptions)) continue;
            pcs.add(pc);
        }
        return pcs;
    }

    @Override
    public void visitEnd() {
        super.visitEnd();
        if (this.weakMatchCount + this.strongMatchCount > 0) {
            this.cv.visitAnnotation(Type.getDescriptor(InstrumentedClass.class), true);
        }
    }
}

