/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation;

import com.newrelic.agent.Agent;
import com.newrelic.agent.config.Config;
import com.newrelic.agent.instrumentation.ClassTransformer;
import com.newrelic.agent.instrumentation.PointCutConfiguration;
import com.newrelic.agent.instrumentation.classmatchers.ClassMatcher;
import com.newrelic.agent.instrumentation.methodmatchers.ExactMethodMatcher;
import com.newrelic.agent.instrumentation.methodmatchers.InstanceMethodMatcher;
import com.newrelic.agent.instrumentation.methodmatchers.MethodMatcher;
import com.newrelic.agent.instrumentation.methodmatchers.OrMethodMatcher;
import com.newrelic.agent.tracers.IgnoreTransactionTracerFactory;
import com.newrelic.agent.tracers.TracerFactory;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PointCut
implements Comparable<PointCut> {
    protected static final int HIGH_PRIORITY = Integer.MAX_VALUE;
    protected static final int DEFAULT_PRIORITY = 20;
    protected static final int LOW_PRIORITY = Integer.MIN_VALUE;
    private final ClassMatcher classMatcher;
    private final MethodMatcher methodMatcher;
    private final PointCutConfiguration config;
    private int priority = 20;

    protected PointCut(PointCutConfiguration config, ClassMatcher classMatcher, MethodMatcher methodMatcher) {
        assert (config != null);
        this.classMatcher = classMatcher;
        this.methodMatcher = methodMatcher;
        this.config = config;
    }

    public MethodMatcher getMethodMatcher() {
        return this.methodMatcher;
    }

    public Config getPointCutConfig() {
        return this.config.getConfiguration();
    }

    public boolean isEnabled() {
        return this.config.isEnabled();
    }

    protected void logInstrumentation(String className, Class<?> classBeingRedefined) {
        if (Agent.isDebugEnabled()) {
            Agent.LOG.log(Level.FINER, "Instrumenting {0} {1}", new Object[]{className, classBeingRedefined == null ? "" : "(Second pass)"});
        }
    }

    public ClassMatcher getClassMatcher() {
        return this.classMatcher;
    }

    public int getPriority() {
        return this.priority;
    }

    protected void setPriority(int priority) {
        this.priority = priority;
    }

    @Override
    public final int compareTo(PointCut pc) {
        return this.getPriority() - pc.getPriority();
    }

    public void noticeTransformerStarted(ClassTransformer classTransformer) {
    }

    public abstract String getTracerFactoryName();

    protected abstract TracerFactory getTracerFactoryImpl();

    public final TracerFactory getTracerFactory() {
        boolean ignore = this.getPointCutConfig().getProperty("ignore_transaction", false);
        return ignore ? new IgnoreTransactionTracerFactory() : this.getTracerFactoryImpl();
    }

    public String toString() {
        return this.config.getName();
    }

    protected static MethodMatcher createMethodMatcher(MethodMatcher ... matchers) {
        return new InstanceMethodMatcher(OrMethodMatcher.getMethodMatcher(matchers));
    }

    protected static MethodMatcher createExactMethodMatcher(String methodName, String ... methodDescriptions) {
        return new InstanceMethodMatcher(new ExactMethodMatcher(methodName, methodDescriptions));
    }
}

