/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation;

import com.newrelic.agent.Agent;
import com.newrelic.agent.config.Config;
import com.newrelic.agent.instrumentation.PointCut;
import com.newrelic.agent.service.ServiceManagerFactory;
import java.util.Collections;
import java.util.Map;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PointCutConfiguration {
    private final String name;
    private final String groupName;
    private final Config config;
    private final boolean enabledByDefault;

    public PointCutConfiguration(Class<? extends PointCut> pc) {
        this(pc.getName(), null, true);
    }

    public PointCutConfiguration(String configurationName) {
        this(configurationName, null, true);
    }

    public PointCutConfiguration(String configurationName, String configurationGroupName, boolean enabledByDefault) {
        this.name = configurationName;
        this.groupName = configurationGroupName;
        this.enabledByDefault = enabledByDefault;
        this.config = this.initConfig(configurationName);
    }

    public final String getName() {
        return this.name;
    }

    public final String getGroupName() {
        return this.groupName;
    }

    public Config getConfiguration() {
        return this.config;
    }

    private Config initConfig(String name) {
        Object pointCutConfig;
        Map config = Collections.emptyMap();
        if (name != null && (pointCutConfig = ServiceManagerFactory.getServiceManager().getConfigService().getAgentConfig().getClassTransformerConfig().getProperty(name)) instanceof Map) {
            config = (Map)pointCutConfig;
        }
        return new Config(config);
    }

    protected final Config getGroupConfig() {
        return this.initConfig(this.groupName);
    }

    public boolean isEnabled() {
        if (!this.getGroupConfig().getProperty("enabled", true).booleanValue()) {
            Agent.LOG.log(Level.INFO, "Disabled point cut \"{0}\" (\"{1}\" group)", new Object[]{this.getName(), this.getGroupName()});
            return false;
        }
        Config pointCutConfig = this.getConfiguration();
        boolean val = pointCutConfig.getProperty("enabled", this.isEnabledByDefault());
        if (val != this.isEnabledByDefault()) {
            Agent.LOG.log(Level.INFO, "{0}abled point cut \"{1}\"", new Object[]{val ? "En" : "Dis", this.getName()});
        }
        return val;
    }

    protected boolean isEnabledByDefault() {
        return this.enabledByDefault;
    }
}

