/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation.classmatchers;

import com.newrelic.agent.instrumentation.classmatchers.ClassMatcher;
import com.newrelic.agent.instrumentation.classmatchers.OrClassMatcher;
import com.newrelic.agent.util.Strings;
import com.newrelic.org.objectweb.asm.ClassReader;
import com.newrelic.org.objectweb.asm.Type;
import java.util.ArrayList;

public class ExactClassMatcher
extends ClassMatcher {
    private final String internalClassName;
    private final String className;

    public ExactClassMatcher(String className) {
        this.internalClassName = className = Strings.fixInternalClassName(className);
        this.className = Type.getObjectType(className).getClassName();
    }

    public boolean isMatch(ClassLoader loader, String className, ClassReader cr) {
        return className.equals(this.internalClassName);
    }

    public boolean isMatch(Class clazz) {
        return clazz.getName().equals(this.className);
    }

    public boolean isNotMatch(ClassLoader loader, String className, ClassReader cr) {
        return !this.isMatch(loader, className, cr);
    }

    public static ClassMatcher or(String ... classNames) {
        ArrayList<ExactClassMatcher> list = new ArrayList<ExactClassMatcher>(classNames.length);
        for (String className : classNames) {
            list.add(new ExactClassMatcher(className));
        }
        return OrClassMatcher.getClassMatcher(list.toArray(new ExactClassMatcher[classNames.length]));
    }

    public String getInternalClassName() {
        return this.internalClassName;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.internalClassName == null ? 0 : this.internalClassName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ExactClassMatcher other = (ExactClassMatcher)obj;
        return !(this.internalClassName == null ? other.internalClassName != null : !this.internalClassName.equals(other.internalClassName));
    }

    public String toString() {
        return "ExactClassMatcher(" + this.internalClassName + ")";
    }
}

