/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation.pointcuts;

import com.newrelic.agent.Transaction;
import com.newrelic.agent.config.Config;
import com.newrelic.agent.instrumentation.PointCutConfiguration;
import com.newrelic.agent.instrumentation.TracerFactoryPointCut;
import com.newrelic.agent.instrumentation.classmatchers.ClassMatcher;
import com.newrelic.agent.instrumentation.methodmatchers.MethodMatcher;
import com.newrelic.agent.instrumentation.yaml.MetricNameFormatFactory;
import com.newrelic.agent.tracers.ClassMethodSignature;
import com.newrelic.agent.tracers.DefaultTracer;
import com.newrelic.agent.tracers.OtherDispatcherTracer;
import com.newrelic.agent.tracers.Tracer;
import com.newrelic.agent.tracers.metricname.MetricNameFormat;
import java.util.Map;

public class ClassMethodNameFormatPointCut
extends TracerFactoryPointCut {
    private final MetricNameFormatFactory metricNameFormatFactory;
    private final boolean dispatcher;
    private final Config config;

    public ClassMethodNameFormatPointCut(MetricNameFormatFactory metricNameFormatFactory, ClassMatcher classMatcher, MethodMatcher methodMatcher, boolean dispatcher, Map configAttributes) {
        super(new PointCutConfiguration((String)null), classMatcher, methodMatcher);
        this.setPriority(19);
        this.metricNameFormatFactory = metricNameFormatFactory;
        this.dispatcher = dispatcher;
        this.config = new Config(configAttributes);
    }

    public Tracer getTracer(Transaction transaction, ClassMethodSignature sig, Object object, Object[] args) {
        MetricNameFormat format = this.metricNameFormatFactory.getMetricNameFormat(sig, object, args);
        if (this.dispatcher) {
            return new OtherDispatcherTracer(transaction, sig, object, format);
        }
        return new DefaultTracer(transaction, sig, object, format);
    }

    public Config getPointCutConfig() {
        return this.config;
    }
}

