/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation.pointcuts;

import com.newrelic.agent.Transaction;
import com.newrelic.agent.instrumentation.ClassTransformer;
import com.newrelic.agent.instrumentation.PointCutConfiguration;
import com.newrelic.agent.instrumentation.TracerFactoryPointCut;
import com.newrelic.agent.instrumentation.classmatchers.ClassMatcher;
import com.newrelic.agent.instrumentation.classmatchers.ExactClassMatcher;
import com.newrelic.agent.instrumentation.classmatchers.OrClassMatcher;
import com.newrelic.agent.instrumentation.pointcuts.PointCut;
import com.newrelic.agent.tracers.ClassMethodSignature;
import com.newrelic.agent.tracers.DefaultTracer;
import com.newrelic.agent.tracers.DispatcherTracer;
import com.newrelic.agent.tracers.Tracer;
import com.newrelic.agent.tracers.metricname.ClassMethodMetricNameFormat;

@PointCut
public class QuartzSystemPointCut
extends TracerFactoryPointCut {
    public QuartzSystemPointCut(ClassTransformer classTransformer) {
        super(new PointCutConfiguration("quartz_system"), (ClassMatcher)new OrClassMatcher(new ExactClassMatcher("org/quartz/impl/jdbcjobstore/JobStoreSupport"), new ExactClassMatcher("org/quartz/simpl/RAMJobStore")), QuartzSystemPointCut.createExactMethodMatcher("acquireNextTrigger", "(Lorg/quartz/core/SchedulingContext;)V", "(Lorg/quartz/core/SchedulingContext;J)Lorg/quartz/Trigger;"));
    }

    public Tracer getTracer(Transaction transaction, ClassMethodSignature sig, Object job, Object[] args) {
        return new QuartzJobTracer(transaction, sig, job);
    }

    private static class QuartzJobTracer
    extends DefaultTracer
    implements DispatcherTracer {
        public QuartzJobTracer(Transaction transaction, ClassMethodSignature sig, Object job) {
            super(transaction, sig, job, new ClassMethodMetricNameFormat(sig, job, "OtherTransaction/Job"));
            transaction.setIgnore(true);
        }
    }
}

