/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation.pointcuts.commons;

import com.newrelic.agent.Agent;
import com.newrelic.agent.Transaction;
import com.newrelic.agent.instrumentation.ClassTransformer;
import com.newrelic.agent.instrumentation.classmatchers.ClassMatcher;
import com.newrelic.agent.instrumentation.classmatchers.InterfaceMatcher;
import com.newrelic.agent.instrumentation.methodmatchers.ExactMethodMatcher;
import com.newrelic.agent.instrumentation.methodmatchers.InstanceMethodMatcher;
import com.newrelic.agent.instrumentation.methodmatchers.MethodMatcher;
import com.newrelic.agent.instrumentation.methodmatchers.OrMethodMatcher;
import com.newrelic.agent.instrumentation.pointcuts.PointCut;
import com.newrelic.agent.instrumentation.pointcuts.commons.HttpCommonsPointCut;
import com.newrelic.agent.tracers.ClassMethodSignature;
import com.newrelic.agent.tracers.Tracer;
import java.net.URI;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;

@PointCut
public class HttpClient4PointCut
extends HttpCommonsPointCut {
    private static final String UNKNOWN_HOST_NAME = "Unknown";
    private static final String HTTP_CLIENT_CLASS_NAME = "org/apache/http/client/HttpClient";
    private static final String EXECUTE_METHOD_NAME = "execute";
    private static final String GET_HOSTNAME_METHOD_NAME = "getHostName";
    private static final String GET_URI_METHOD_NAME = "getURI";
    private static final String METHOD_SIGNATURE_1 = "(Lorg/apache/http/client/methods/HttpUriRequest;)Lorg/apache/http/HttpResponse;";
    private static final String METHOD_SIGNATURE_2 = "(Lorg/apache/http/client/methods/HttpUriRequest;Lorg/apache/http/protocol/HttpContext;)Lorg/apache/http/HttpResponse;";
    private static final String METHOD_SIGNATURE_3 = "(Lorg/apache/http/HttpHost;Lorg/apache/http/HttpRequest;)Lorg/apache/http/HttpResponse;";
    private static final String METHOD_SIGNATURE_4 = "(Lorg/apache/http/HttpHost;Lorg/apache/http/HttpRequest;Lorg/apache/http/protocol/HttpContext;)Lorg/apache/http/HttpResponse;";
    private static final String METHOD_SIGNATURE_5 = "(Lorg/apache/http/client/methods/HttpUriRequest;Lorg/apache/http/client/ResponseHandler;)Ljava/lang/Object;";
    private static final String METHOD_SIGNATURE_6 = "(Lorg/apache/http/client/methods/HttpUriRequest;Lorg/apache/http/client/ResponseHandler;Lorg/apache/http/protocol/HttpContext;)Ljava/lang/Object;";
    private static final String METHOD_SIGNATURE_7 = "(Lorg/apache/http/HttpHost;Lorg/apache/http/HttpRequest;Lorg/apache/http/client/ResponseHandler;)Ljava/lang/Object;";
    private static final String METHOD_SIGNATURE_8 = "(Lorg/apache/http/HttpHost;Lorg/apache/http/HttpRequest;Lorg/apache/http/client/ResponseHandler;Lorg/apache/http/protocol/HttpContext;)Ljava/lang/Object;";
    private final Logger logger = Agent.LOG.getChildLogger(this.getClass());

    public HttpClient4PointCut(ClassTransformer classTransformer) {
        super((Class<? extends HttpCommonsPointCut>)HttpClient4PointCut.class, (ClassMatcher)new InterfaceMatcher(HTTP_CLIENT_CLASS_NAME), (MethodMatcher)new InstanceMethodMatcher(OrMethodMatcher.getMethodMatcher(new ExactMethodMatcher(EXECUTE_METHOD_NAME, METHOD_SIGNATURE_1, METHOD_SIGNATURE_2, METHOD_SIGNATURE_3, METHOD_SIGNATURE_4, METHOD_SIGNATURE_5, METHOD_SIGNATURE_6, METHOD_SIGNATURE_7, METHOD_SIGNATURE_8))));
    }

    protected Tracer getTracerImpl(Transaction transaction, ClassMethodSignature sig, Object httpClient, Object[] args) {
        String host;
        try {
            host = this.getHost(sig, args);
        }
        catch (Throwable e) {
            String msg = MessageFormat.format("Instrumentation error invoking {0} in {1}: {2}", sig, this.getClass().getName(), e);
            if (this.logger.isLoggable(Level.FINEST)) {
                this.logger.log(Level.FINEST, msg, e);
            } else {
                this.logger.log(Level.FINE, msg);
            }
            host = UNKNOWN_HOST_NAME;
        }
        return super.getTracer(transaction, sig, httpClient, host);
    }

    private String getHost(ClassMethodSignature sig, Object[] args) throws Exception {
        Object httpUriRequest;
        String methodDesc = sig.getMethodDesc();
        if (methodDesc == METHOD_SIGNATURE_3 || methodDesc == METHOD_SIGNATURE_4 || methodDesc == METHOD_SIGNATURE_7 || methodDesc == METHOD_SIGNATURE_8) {
            Object httpHost = args[0];
            if (httpHost != null) {
                return (String)httpHost.getClass().getMethod(GET_HOSTNAME_METHOD_NAME, new Class[0]).invoke(httpHost, new Object[0]);
            }
        } else if ((methodDesc == METHOD_SIGNATURE_1 || methodDesc == METHOD_SIGNATURE_2 || methodDesc == METHOD_SIGNATURE_5 || methodDesc == METHOD_SIGNATURE_6) && (httpUriRequest = args[0]) != null) {
            URI uri = (URI)httpUriRequest.getClass().getMethod(GET_URI_METHOD_NAME, new Class[0]).invoke(httpUriRequest, new Object[0]);
            return uri.getHost();
        }
        return UNKNOWN_HOST_NAME;
    }
}

