/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation.pointcuts.commons;

import com.newrelic.agent.Agent;
import com.newrelic.agent.Transaction;
import com.newrelic.agent.instrumentation.ClassTransformer;
import com.newrelic.agent.instrumentation.classmatchers.ClassMatcher;
import com.newrelic.agent.instrumentation.classmatchers.ExactClassMatcher;
import com.newrelic.agent.instrumentation.pointcuts.PointCut;
import com.newrelic.agent.instrumentation.pointcuts.commons.BasicHostInfo;
import com.newrelic.agent.instrumentation.pointcuts.commons.HttpCommonsPointCut;
import com.newrelic.agent.tracers.ClassMethodSignature;
import com.newrelic.agent.tracers.Tracer;
import java.util.logging.Level;

@PointCut
public class HttpMethodBasePointCut
extends HttpCommonsPointCut {
    public HttpMethodBasePointCut(ClassTransformer classTransformer) {
        super((Class<? extends HttpCommonsPointCut>)HttpMethodBasePointCut.class, (ClassMatcher)new ExactClassMatcher("com/newrelic/org/apache/commons/httpclient/HttpMethodBase"), HttpMethodBasePointCut.createExactMethodMatcher("getResponseBody", "()[B"));
    }

    protected Tracer getTracerImpl(Transaction transaction, ClassMethodSignature sig, Object httpMethod, Object[] args) {
        try {
            Object hostConfig = httpMethod.getClass().getMethod("getHostConfiguration", new Class[0]).invoke(httpMethod, new Object[0]);
            return super.getTracer(transaction, sig, httpMethod, new BasicHostInfo(hostConfig, httpMethod));
        }
        catch (Throwable t) {
            Agent.LOG.log(Level.FINE, "Unable to get the host configuration for an HttpMethod", t);
            return null;
        }
    }
}

