/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation.pointcuts.container;

import com.newrelic.agent.Agent;
import com.newrelic.agent.Transaction;
import com.newrelic.agent.instrumentation.ClassTransformer;
import com.newrelic.agent.instrumentation.TracerFactoryPointCut;
import com.newrelic.agent.instrumentation.classmatchers.ClassMatcher;
import com.newrelic.agent.instrumentation.classmatchers.ExactClassMatcher;
import com.newrelic.agent.instrumentation.pointcuts.PointCut;
import com.newrelic.agent.tracers.ClassMethodSignature;
import com.newrelic.agent.tracers.DefaultTracer;
import com.newrelic.agent.tracers.Tracer;
import com.newrelic.agent.tracers.metricname.SimpleMetricNameFormat;

@PointCut
public class JasperCompilerPointCut
extends TracerFactoryPointCut {
    public JasperCompilerPointCut(ClassTransformer classTransformer) {
        super(JasperCompilerPointCut.class, (ClassMatcher)new ExactClassMatcher("org/apache/jasper/compiler/Compiler"), JasperCompilerPointCut.createExactMethodMatcher("compile", "(ZZ)V"));
    }

    public Tracer getTracer(Transaction transaction, ClassMethodSignature sig, Object compiler, Object[] args) {
        try {
            String page;
            Object context = compiler.getClass().getMethod("getCompilationContext", new Class[0]).invoke(compiler, new Object[0]);
            if (context != null && (page = (String)context.getClass().getMethod("getJspFile", new Class[0]).invoke(context, new Object[0])) != null) {
                DefaultTracer tracer = new DefaultTracer(transaction, sig, compiler, new SimpleMetricNameFormat("View" + page.replace('.', '_') + "/Compile"));
                tracer.setRecordMetric(false);
                return tracer;
            }
        }
        catch (Throwable t) {
            Agent.LOG.severe("Unable to generate a Jasper compilation metric: " + t.getMessage());
        }
        return null;
    }
}

