/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation.pointcuts.container.coldfusion;

import com.newrelic.agent.Agent;
import com.newrelic.agent.Transaction;
import com.newrelic.agent.instrumentation.ClassTransformer;
import com.newrelic.agent.instrumentation.DefaultPointCut;
import com.newrelic.agent.instrumentation.PointCutConfiguration;
import com.newrelic.agent.instrumentation.classmatchers.ExactClassMatcher;
import com.newrelic.agent.instrumentation.pointcuts.PointCut;
import com.newrelic.agent.service.ServiceManagerFactory;
import com.newrelic.agent.tracers.ClassMethodSignature;
import com.newrelic.agent.tracers.Tracer;
import com.newrelic.agent.tracers.servlet.BasicRequestDispatcherTracer;
import com.newrelic.agent.tracers.servlet.GenericRequest;
import com.newrelic.agent.tracers.servlet.HttpRequest;
import com.newrelic.agent.tracers.servlet.HttpResponse;
import com.newrelic.agent.tracers.servlet.RequestDispatcherTracerFactory;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;

@PointCut
public class ColdFusionDispatcherPointCut
extends DefaultPointCut {
    private static final String SERVLET_REQUEST_INTERFACE = "javax.servlet.ServletRequest";

    public ColdFusionDispatcherPointCut(ClassTransformer classTransformer) {
        super(new PointCutConfiguration(ColdFusionDispatcherPointCut.class), new DispatcherTracerFactory(), new ExactClassMatcher("jrun/servlet/ServletEngineService"), ColdFusionDispatcherPointCut.createExactMethodMatcher("dispatch", "(Ljrun/servlet/ServletConnection;)V"));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ColdFusionResponse
    implements HttpResponse {
        private final Class<?> servletConnectionClass;
        private final Object servletConnection;

        public ColdFusionResponse(Class<?> servletConnectionClass, Object servletConnection) {
            this.servletConnectionClass = servletConnectionClass;
            this.servletConnection = servletConnection;
        }

        @Override
        public int getResponseStatus() throws Exception {
            Field statusField = this.servletConnectionClass.getDeclaredField("status");
            statusField.setAccessible(true);
            return statusField.getInt(this.servletConnection);
        }

        @Override
        public String getResponseStatusMessage() throws Exception {
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ColdFusionRequest
    implements HttpRequest {
        private final Class<?> servletConnectionClass;
        private final Object servletConnection;
        private HttpRequest delegate;
        private Object request;

        public ColdFusionRequest(Class<?> servletConnectionClass, Object servletConnection) {
            this.servletConnectionClass = servletConnectionClass;
            this.servletConnection = servletConnection;
        }

        private HttpRequest getDelegate() throws Exception {
            if (this.delegate == null) {
                Method getRequest = this.servletConnectionClass.getDeclaredMethod("getRequestWrapper", new Class[0]);
                getRequest.setAccessible(true);
                this.request = getRequest.invoke(this.servletConnection, new Object[0]);
                this.delegate = new GenericRequest(this.request);
            }
            return this.delegate;
        }

        @Override
        public String getHeader(String name) throws Exception {
            return this.getDelegate().getHeader(name);
        }

        @Override
        public Map getRequestParameterMap(Set<String> excludes2) throws Exception {
            Class<?> requestClass = this.request.getClass().getClassLoader().loadClass(ColdFusionDispatcherPointCut.SERVLET_REQUEST_INTERFACE);
            Set<String> excludes = ServiceManagerFactory.getServiceManager().getConfigService().getAgentConfig().getIgnoredParams();
            Enumeration nameEnumeration = (Enumeration)requestClass.getMethod("getParameterNames", new Class[0]).invoke(this.request, new Object[0]);
            HashMap<String, String[]> requestParameters = new HashMap<String, String[]>();
            Method getParamValues = requestClass.getMethod("getParameterValues", String.class);
            while (nameEnumeration.hasMoreElements()) {
                String name = nameEnumeration.nextElement().toString();
                if (excludes.contains(name)) continue;
                String[] values = (String[])getParamValues.invoke(this.request, name);
                requestParameters.put(name, values);
            }
            return requestParameters;
        }

        @Override
        public String getRequestURI() throws Exception {
            return this.getDelegate().getRequestURI();
        }
    }

    private static class DispatcherTracerFactory
    extends RequestDispatcherTracerFactory {
        private DispatcherTracerFactory() {
        }

        protected Tracer getTracerImpl(Transaction transaction, ClassMethodSignature sig, Object engineService, Object[] args) throws Exception {
            try {
                Class<?> servletConnectionClass = engineService.getClass().getClassLoader().loadClass("jrun.servlet.ServletConnection");
                ColdFusionRequest httpRequest = new ColdFusionRequest(servletConnectionClass, args[0]);
                ColdFusionResponse httpResponse = new ColdFusionResponse(servletConnectionClass, args[0]);
                return new BasicRequestDispatcherTracer(transaction, sig, engineService, httpRequest, httpResponse);
            }
            catch (Exception ex) {
                Agent.LOG.severe("Unable to create a ColdFusion dispatcher tracer : " + ex.getLocalizedMessage());
                Agent.LOG.log(Level.FINER, ex.getLocalizedMessage(), ex);
                return null;
            }
        }
    }
}

