/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation.pointcuts.container.jetty;

import com.newrelic.agent.Agent;
import com.newrelic.agent.Transaction;
import com.newrelic.agent.instrumentation.ClassTransformer;
import com.newrelic.agent.instrumentation.PointCutConfiguration;
import com.newrelic.agent.instrumentation.TracerFactoryPointCut;
import com.newrelic.agent.instrumentation.classmatchers.ClassMatcher;
import com.newrelic.agent.instrumentation.classmatchers.ExactClassMatcher;
import com.newrelic.agent.instrumentation.pointcuts.PointCut;
import com.newrelic.agent.tracers.ClassMethodSignature;
import com.newrelic.agent.tracers.MethodExitTracer;
import com.newrelic.agent.tracers.Tracer;
import java.util.logging.Level;

@PointCut
public class ErrorInterceptorPointCut
extends TracerFactoryPointCut {
    private static final String EXCEPTION_ATTRIBUTE_NAME = "javax.servlet.error.exception";

    public ErrorInterceptorPointCut(ClassTransformer classTransformer) {
        super(new PointCutConfiguration(ErrorInterceptorPointCut.class.getName(), "jetty_server", true), (ClassMatcher)new ExactClassMatcher("org/mortbay/jetty/servlet/ErrorPageErrorHandler"), ErrorInterceptorPointCut.createExactMethodMatcher("handle", "(Ljava/lang/String;Ljavax/servlet/http/HttpServletRequest;Ljavax/servlet/http/HttpServletResponse;I)V"));
    }

    public Tracer getTracer(Transaction transaction, ClassMethodSignature sig, Object standardHostValve, Object[] args) {
        Object request = args[1];
        try {
            final Throwable throwable = (Throwable)request.getClass().getMethod("getAttribute", String.class).invoke(request, EXCEPTION_ATTRIBUTE_NAME);
            return new MethodExitTracer(sig, transaction){

                protected void doFinish(int opcode, Object returnValue) {
                    if (throwable != null) {
                        this.getTransaction().setThrowable(throwable);
                    }
                }
            };
        }
        catch (Throwable t) {
            Agent.LOG.log(Level.SEVERE, t.toString(), t);
            return null;
        }
    }
}

