/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation.pointcuts.container.oc4j;

import com.newrelic.agent.Transaction;
import com.newrelic.agent.instrumentation.ClassTransformer;
import com.newrelic.agent.instrumentation.classmatchers.ClassMatcher;
import com.newrelic.agent.instrumentation.classmatchers.ExactClassMatcher;
import com.newrelic.agent.instrumentation.pointcuts.PointCut;
import com.newrelic.agent.tracers.ClassMethodSignature;
import com.newrelic.agent.tracers.servlet.BasicRequestDispatcherPointCut;
import com.newrelic.agent.tracers.servlet.GenericRequest;
import com.newrelic.agent.tracers.servlet.HttpRequest;
import com.newrelic.agent.tracers.servlet.HttpResponse;
import java.lang.reflect.Field;

@PointCut
public class EvermindDispatcherPointCut
extends BasicRequestDispatcherPointCut {
    static final String HTTP_REQUEST_HANDLER_CLASS_NAME = "com/evermind/server/http/HttpRequestHandler";

    public EvermindDispatcherPointCut(ClassTransformer classTransformer) {
        super(EvermindDispatcherPointCut.class, (ClassMatcher)new ExactClassMatcher(HTTP_REQUEST_HANDLER_CLASS_NAME), EvermindDispatcherPointCut.createExactMethodMatcher("doProcessRequest", "(Lcom/evermind/server/ApplicationServerThread;Lcom/evermind/server/http/EvermindHttpServletRequest;Lcom/evermind/server/http/EvermindHttpServletResponse;Ljava/io/InputStream;Ljava/io/OutputStream;Z)Z"));
    }

    protected HttpRequest getRequest(Transaction transaction, ClassMethodSignature sig, Object object, Object[] args) throws Exception {
        return new GenericRequest(args[1], args[1].getClass());
    }

    protected HttpResponse getResponse(Transaction transaction, ClassMethodSignature sig, Object object, Object[] args) throws Exception {
        return new EvermindResponse(args[2]);
    }

    private static class EvermindResponse
    implements HttpResponse {
        private final Object response;

        public EvermindResponse(Object response) {
            this.response = response;
        }

        public int getResponseStatus() throws Exception {
            Field statusField = this.response.getClass().getDeclaredField("status");
            statusField.setAccessible(true);
            return statusField.getInt(this.response);
        }

        public String getResponseStatusMessage() throws Exception {
            return null;
        }
    }
}

