/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation.pointcuts.container.resin;

import com.newrelic.agent.Transaction;
import com.newrelic.agent.instrumentation.ClassTransformer;
import com.newrelic.agent.instrumentation.classmatchers.ClassMatcher;
import com.newrelic.agent.instrumentation.classmatchers.ExactClassMatcher;
import com.newrelic.agent.instrumentation.pointcuts.PointCut;
import com.newrelic.agent.tracers.ClassMethodSignature;
import com.newrelic.agent.tracers.servlet.BasicRequestDispatcherPointCut;
import com.newrelic.agent.tracers.servlet.GenericRequest;
import com.newrelic.agent.tracers.servlet.HttpRequest;
import com.newrelic.agent.tracers.servlet.HttpResponse;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Set;

@PointCut
public class ServletInvocationPointCut
extends BasicRequestDispatcherPointCut {
    private static final String SERVLET_INVOCATION_CLASS_NAME = "com/caucho/server/dispatch/ServletInvocation";

    public ServletInvocationPointCut(ClassTransformer classTransformer) {
        super(ServletInvocationPointCut.class, (ClassMatcher)new ExactClassMatcher(SERVLET_INVOCATION_CLASS_NAME), ServletInvocationPointCut.createExactMethodMatcher("service", "(Ljavax/servlet/ServletRequest;Ljavax/servlet/ServletResponse;)V"));
    }

    public void noticeTransformerStarted(ClassTransformer classTransformer) {
        if (System.getProperty("resin.home") != null) {
            ServletInvocationPointCut.retransformServletInvocationClass();
        }
    }

    static void retransformServletInvocationClass() {
    }

    protected HttpRequest getRequest(Transaction transaction, ClassMethodSignature sig, Object object, Object[] args) throws Exception {
        return new ResinRequest(args[0], transaction.getAgentConfig().getIgnoredParams());
    }

    protected HttpResponse getResponse(Transaction transaction, ClassMethodSignature sig, Object object, Object[] args) throws Exception {
        return new ResinResponse(args[1]);
    }

    private static class ResinResponse
    implements HttpResponse {
        private final Object response;

        public ResinResponse(Object response) {
            this.response = response;
        }

        public int getResponseStatus() throws Exception {
            Method method;
            try {
                method = this.response.getClass().getMethod("getStatusCode", new Class[0]);
            }
            catch (NoSuchMethodException e) {
                method = this.response.getClass().getMethod("getStatus", new Class[0]);
            }
            method.setAccessible(true);
            return (Integer)method.invoke(this.response, new Object[0]);
        }

        public String getResponseStatusMessage() throws Exception {
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ResinRequest
    extends GenericRequest {
        private Map paramMap;
        private String uri = super.getRequestURI();

        public ResinRequest(Object request, Set<String> excludes) throws Exception {
            super(request);
            this.paramMap = super.getRequestParameterMap(excludes);
        }

        @Override
        public Map getRequestParameterMap(Set<String> excludes) throws Exception {
            return this.paramMap;
        }

        @Override
        public String getRequestURI() throws Exception {
            return this.uri;
        }
    }
}

