/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation.pointcuts.container.tomcat;

import com.newrelic.agent.Agent;
import com.newrelic.agent.Transaction;
import com.newrelic.agent.instrumentation.ClassTransformer;
import com.newrelic.agent.instrumentation.PointCutConfiguration;
import com.newrelic.agent.instrumentation.TracerFactoryPointCut;
import com.newrelic.agent.instrumentation.classmatchers.ClassMatcher;
import com.newrelic.agent.instrumentation.classmatchers.ExactClassMatcher;
import com.newrelic.agent.instrumentation.classmatchers.OrClassMatcher;
import com.newrelic.agent.instrumentation.pointcuts.PointCut;
import com.newrelic.agent.tracers.ClassMethodSignature;
import com.newrelic.agent.tracers.Tracer;
import java.util.logging.Level;

@PointCut
public class ErrorInterceptorPointCut
extends TracerFactoryPointCut {
    private static final String EXCEPTION_ATTRIBUTE_NAME = "javax.servlet.error.exception";

    public ErrorInterceptorPointCut(ClassTransformer classTransformer) {
        super(new PointCutConfiguration("catalina_response", "tomcat_instrumentation", true), (ClassMatcher)new OrClassMatcher(new ExactClassMatcher("org/apache/catalina/connector/Response"), new ExactClassMatcher("org/apache/catalina/Response")), ErrorInterceptorPointCut.createExactMethodMatcher("sendError", "(ILjava/lang/String;)V"));
    }

    public Tracer getTracer(Transaction transaction, ClassMethodSignature sig, Object response, Object[] args) {
        try {
            Object request = response.getClass().getMethod("getRequest", new Class[0]).invoke(response, new Object[0]);
            Throwable throwable = (Throwable)request.getClass().getMethod("getAttribute", String.class).invoke(request, EXCEPTION_ATTRIBUTE_NAME);
            if (throwable != null) {
                transaction.setThrowable(throwable);
            }
        }
        catch (Throwable t) {
            Agent.LOG.log(Level.FINE, "Tomcat StandardHostValve : Unable to capture throwable", t);
        }
        return null;
    }
}

