/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation.pointcuts.container.tomcat;

import com.newrelic.agent.Transaction;
import com.newrelic.agent.instrumentation.ClassTransformer;
import com.newrelic.agent.instrumentation.PointCutConfiguration;
import com.newrelic.agent.instrumentation.classmatchers.ClassMatcher;
import com.newrelic.agent.instrumentation.classmatchers.ExactClassMatcher;
import com.newrelic.agent.instrumentation.classmatchers.OrClassMatcher;
import com.newrelic.agent.instrumentation.pointcuts.PointCut;
import com.newrelic.agent.tracers.ClassMethodSignature;
import com.newrelic.agent.tracers.servlet.BasicRequestDispatcherPointCut;
import com.newrelic.agent.tracers.servlet.GenericRequest;
import com.newrelic.agent.tracers.servlet.HttpRequest;
import com.newrelic.agent.tracers.servlet.HttpResponse;
import java.util.Map;
import java.util.Set;

@PointCut
public class TomcatDispatcherPointCut
extends BasicRequestDispatcherPointCut {
    static final String TOMCAT_INSTRUMENTATION_GROUP_NAME = "tomcat_instrumentation";

    public TomcatDispatcherPointCut(ClassTransformer classTransformer) {
        super(new PointCutConfiguration(TomcatDispatcherPointCut.class.getName(), TOMCAT_INSTRUMENTATION_GROUP_NAME, true), (ClassMatcher)new OrClassMatcher(new ExactClassMatcher("org/apache/coyote/tomcat5/CoyoteAdapter"), new ExactClassMatcher("org/apache/catalina/connector/CoyoteAdapter")), TomcatDispatcherPointCut.createExactMethodMatcher("service", "(Lorg/apache/coyote/Request;Lorg/apache/coyote/Response;)V", "(Lcom/sun/grizzly/tcp/Request;Lcom/sun/grizzly/tcp/Response;)V"));
    }

    protected HttpRequest getRequest(Transaction transaction, ClassMethodSignature sig, Object object, Object[] args) throws Exception {
        return new TomcatRequest(args[0]);
    }

    protected HttpResponse getResponse(Transaction transaction, ClassMethodSignature sig, Object object, Object[] args) throws Exception {
        return new TomcatResponse(args[1]);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TomcatRequest
    extends GenericRequest {
        public TomcatRequest(Object request) {
            super(request, request.getClass());
        }

        @Override
        public Map getRequestParameterMap(Set<String> excludes) throws Exception {
            Object parameters = this.getRequest().getClass().getMethod("getParameters", new Class[0]).invoke(this.getRequest(), new Object[0]);
            return GenericRequest.getRequestParametersFromNamesAndValues(parameters);
        }

        @Override
        public String getRequestURI() throws Exception {
            Object requestUri = this.getRequest().getClass().getMethod("requestURI", new Class[0]).invoke(this.getRequest(), new Object[0]);
            if (requestUri != null) {
                return requestUri.toString();
            }
            return null;
        }
    }

    private static class TomcatResponse
    implements HttpResponse {
        private final Object response;

        public TomcatResponse(Object response) {
            this.response = response;
        }

        public int getResponseStatus() throws Exception {
            return (Integer)this.response.getClass().getMethod("getStatus", new Class[0]).invoke(this.response, new Object[0]);
        }

        public String getResponseStatusMessage() throws Exception {
            return (String)this.response.getClass().getMethod("getMessage", new Class[0]).invoke(this.response, new Object[0]);
        }
    }
}

