/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation.pointcuts.container.tomcat;

import com.newrelic.agent.Agent;
import com.newrelic.agent.IRPMService;
import com.newrelic.agent.samplers.MetricSampler;
import com.newrelic.agent.service.ServiceManagerFactory;
import com.newrelic.agent.stats.StatsEngine;
import com.newrelic.agent.util.Strings;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import javax.management.MBeanServer;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import org.apache.catalina.core.StandardServer;
import org.apache.catalina.mbeans.MBeanUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TomcatSampler
implements MetricSampler {
    public static final String THREAD_POOL_CURR_BUSY_ATTRIBUTE = "currentThreadsBusy";
    public static final String THREAD_POOL_CURR_COUNT_ATTRIBUTE = "currentThreadCount";
    public static final String THREAD_POOL_MAX_THREADS_ATTRIBUTE = "maxThreads";
    public static final String DB_POOL_NUM_ACTIVE_ATTRIBUTE = "numActive";
    public static final String DB_POOL_MAX_ACTIVE_ATTRIBUTE = "maxActive";
    public static final String DB_POOL_DRIVER_CLASS_NAME_ATTRIBUTE = "driverClassName";
    private MBeanServer mbeanServer;
    private String domain;
    private StandardServer server;
    private final List<ObjectName> threadPoolNames;
    private LinkedList<ObjectName> dataSoureNames;

    public TomcatSampler(Object serverObject) throws Exception {
        this.server = (StandardServer)serverObject;
        this.domain = this.server.getDomain();
        this.mbeanServer = MBeanUtils.createServer();
        this.threadPoolNames = new LinkedList<ObjectName>();
        ObjectName serverName = new ObjectName(this.domain + ":type=Server");
        try {
            String serverInfo = (String)this.mbeanServer.getAttribute(serverName, "serverInfo");
            String[] split = serverInfo.split("/");
            if (split.length > 1) {
                String version = split[1];
                ServiceManagerFactory.getServiceManager().getEnvironmentService().getEnvironment().setDispatcherVersion(version);
            }
        }
        catch (Exception e) {
            Agent.LOG.log(Level.FINER, "Unable to get Apache Tomcat version number");
        }
        Set<ObjectInstance> threadPoolMBeans = this.mbeanServer.queryMBeans(new ObjectName(this.domain + ":type=ThreadPool,*"), null);
        for (ObjectInstance instance : threadPoolMBeans) {
            try {
                Object port = this.mbeanServer.getAttribute(instance.getObjectName(), "port");
                if (port == null) continue;
                this.threadPoolNames.add(instance.getObjectName());
            }
            catch (Exception e) {}
        }
        this.dataSoureNames = new LinkedList();
        Set<ObjectInstance> dataSourceMBeans = this.mbeanServer.queryMBeans(new ObjectName(this.domain + ":type=DataSource,*"), null);
        for (ObjectInstance ds : dataSourceMBeans) {
            this.dataSoureNames.add(ds.getObjectName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void sample() {
        try {
            HashMap<String, Number> metricValues = new HashMap<String, Number>();
            this.recordRequestThreadMetrics(metricValues);
            this.recordDataSourceMetrics(metricValues);
            List<IRPMService> rpmServices = ServiceManagerFactory.getServiceManager().getRPMServiceManager().getRPMServices();
            for (IRPMService rpmService : rpmServices) {
                StatsEngine statsEngine = rpmService.getStatsEngine();
                Object object = statsEngine.getHarvestLock();
                synchronized (object) {
                    for (Map.Entry metricValue : metricValues.entrySet()) {
                        statsEngine.getStats((String)metricValue.getKey()).recordDataPoint(((Number)metricValue.getValue()).floatValue());
                    }
                }
            }
            return;
        }
        catch (Throwable t) {
            Agent.LOG.info("Unable to record Tomcat thread pool metrics: " + t.getMessage());
        }
    }

    private void recordRequestThreadMetrics(Map<String, Number> metricValues) throws Exception {
        for (ObjectName tpName : this.threadPoolNames) {
            Integer max = (Integer)this.mbeanServer.getAttribute(tpName, THREAD_POOL_MAX_THREADS_ATTRIBUTE);
            Integer busyCount = (Integer)this.mbeanServer.getAttribute(tpName, THREAD_POOL_CURR_BUSY_ATTRIBUTE);
            Integer currentCount = (Integer)this.mbeanServer.getAttribute(tpName, THREAD_POOL_CURR_COUNT_ATTRIBUTE);
            String threadPoolName = tpName.getKeyProperty("name");
            metricValues.put(MessageFormat.format("RequestThread/{0}/{1}", threadPoolName, "total"), currentCount);
            metricValues.put(MessageFormat.format("RequestThread/{0}/{1}", threadPoolName, "busy"), busyCount);
            if (max == null || busyCount == null) continue;
            double busyPercentage = busyCount.doubleValue() / max.doubleValue();
            metricValues.put("Instance/Busy", busyPercentage);
        }
    }

    private void recordDataSourceMetrics(Map<String, Number> metricValues) throws Exception {
        for (ObjectName dsName : this.dataSoureNames) {
            String poolName = Strings.unquote(dsName.getKeyProperty("name"));
            String driverName = (String)this.mbeanServer.getAttribute(dsName, DB_POOL_DRIVER_CLASS_NAME_ATTRIBUTE);
            Integer max = (Integer)this.mbeanServer.getAttribute(dsName, DB_POOL_MAX_ACTIVE_ATTRIBUTE);
            Integer num = (Integer)this.mbeanServer.getAttribute(dsName, DB_POOL_NUM_ACTIVE_ATTRIBUTE);
            metricValues.put(MessageFormat.format("DatabasePool/{0}/{1}/{2}", driverName, poolName, DB_POOL_MAX_ACTIVE_ATTRIBUTE), max);
            metricValues.put(MessageFormat.format("DatabasePool/{0}/{1}/{2}", driverName, poolName, DB_POOL_NUM_ACTIVE_ATTRIBUTE), num);
        }
    }
}

