/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation.pointcuts.database;

import com.newrelic.agent.Agent;
import com.newrelic.agent.MetricSpec;
import com.newrelic.agent.Transaction;
import com.newrelic.agent.TransactionData;
import com.newrelic.agent.config.TransactionTracerConfig;
import com.newrelic.agent.instrumentation.ClassTransformer;
import com.newrelic.agent.instrumentation.PointCutConfiguration;
import com.newrelic.agent.instrumentation.TracerFactoryPointCut;
import com.newrelic.agent.instrumentation.classmatchers.ClassMatcher;
import com.newrelic.agent.instrumentation.classmatchers.InterfaceMatcher;
import com.newrelic.agent.instrumentation.methodmatchers.ExactMethodMatcher;
import com.newrelic.agent.instrumentation.pointcuts.PointCut;
import com.newrelic.agent.instrumentation.pointcuts.database.ConnectionFactory;
import com.newrelic.agent.instrumentation.pointcuts.database.ReflectiveDataSource;
import com.newrelic.agent.instrumentation.pointcuts.database.SqlDriverPointCut;
import com.newrelic.agent.service.ServiceManagerFactory;
import com.newrelic.agent.stats.StatsEngine;
import com.newrelic.agent.tracers.ClassMethodSignature;
import com.newrelic.agent.tracers.DatabaseTracer;
import com.newrelic.agent.tracers.DefaultTracer;
import com.newrelic.agent.tracers.Tracer;
import com.newrelic.agent.tracers.metricname.ClassMethodMetricNameFormat;
import com.newrelic.agent.tracers.metricname.MetricNameFormat;
import com.newrelic.org.objectweb.asm.Type;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.concurrent.TimeUnit;
import javax.sql.DataSource;

@PointCut
public class DataSourcePointCut
extends TracerFactoryPointCut {
    private static final String[] DATA_SOURCE_OPTIONS = new String[]{"getDatabaseName", "getDatabasename", "getUrl", "getURL", "getDataSourceName", "getDescription"};
    private static final String[] C3P0_OPTIONS = new String[]{"getJdbcUrl"};
    private final boolean explainsEnabled;

    public DataSourcePointCut(ClassTransformer classTransformer) {
        super(new PointCutConfiguration("jdbc_data_source"), (ClassMatcher)new InterfaceMatcher(Type.getInternalName(DataSource.class)), DataSourcePointCut.createMethodMatcher(new ExactMethodMatcher("getConnection", "()" + Type.getDescriptor(Connection.class)), new ExactMethodMatcher("getConnection", "(Ljava/lang/String;Ljava/lang/String;)" + Type.getDescriptor(Connection.class))));
        TransactionTracerConfig transactionTracerConfig = ServiceManagerFactory.getServiceManager().getConfigService().getAgentConfig().getTransactionTracerConfig();
        this.explainsEnabled = transactionTracerConfig.isEnabled() && transactionTracerConfig.isExplainEnabled();
    }

    public Tracer getTracer(Transaction transaction, ClassMethodSignature sig, Object dataSource, Object[] args) {
        DataSource ds;
        ClassMethodMetricNameFormat metricName = new ClassMethodMetricNameFormat(sig, dataSource);
        Tracer parentTracer = transaction.getLastTracer();
        if (!this.explainsEnabled || transaction.isOverTracerSegmentLimit()) {
            ClassMethodSignature parentSig;
            if (parentTracer != null && (parentSig = parentTracer.getClassMethodSignature()).getClassName().equals(sig.getClassName()) && parentSig.getMethodName().equals(sig.getMethodName())) {
                return null;
            }
            return new ConnectionTracer(transaction, sig, dataSource, metricName);
        }
        if (parentTracer instanceof DataSourceTracer) {
            return null;
        }
        if (dataSource instanceof DataSource) {
            ds = (DataSource)dataSource;
        } else {
            try {
                ds = new ReflectiveDataSource(dataSource);
            }
            catch (ClassNotFoundException e) {
                Agent.LOG.severe(dataSource.getClass().getName() + " does not appear to be an instance of DataSource");
                return new ConnectionTracer(transaction, sig, dataSource, metricName);
            }
        }
        return new DataSourceTracer(transaction, sig, ds, args, metricName);
    }

    private static abstract class AConnectionFactory
    implements ConnectionFactory {
        private String url;
        private final DataSource dataSource;

        public AConnectionFactory(DataSource dataSource) {
            this.dataSource = dataSource;
        }

        public String getUrl() {
            return this.url;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        protected DataSource getDataSource() {
            return this.dataSource;
        }
    }

    private static class DataSourceConnectionFactory
    extends AConnectionFactory {
        private final String password;
        private final String username;

        public DataSourceConnectionFactory(DataSource dataSource, String username, String password) {
            super(dataSource);
            this.username = username;
            this.password = password;
        }

        public Connection getConnection() throws SQLException {
            return this.getDataSource().getConnection(this.username, this.password);
        }
    }

    private static class NoArgsDataSourceConnectionFactory
    extends AConnectionFactory {
        public NoArgsDataSourceConnectionFactory(DataSource dataSource) {
            super(dataSource);
        }

        public Connection getConnection() throws SQLException {
            return this.getDataSource().getConnection();
        }
    }

    private static class DataSourceTracer
    extends ConnectionTracer {
        private AConnectionFactory connectionFactory;

        public DataSourceTracer(Transaction transaction, ClassMethodSignature sig, DataSource dataSource, Object[] args, ClassMethodMetricNameFormat metricName) {
            super(transaction, sig, dataSource, metricName);
            this.connectionFactory = args.length == 2 ? new DataSourceConnectionFactory(dataSource, (String)args[0], (String)args[1]) : new NoArgsDataSourceConnectionFactory(dataSource);
        }

        protected void doFinish(int opcode, Object connection) {
            if (connection != null) {
                SqlDriverPointCut.putConnectionFactory(this.getTransaction(), (Connection)connection, this.connectionFactory);
            }
        }

        private String getUrl() {
            String name;
            DataSource dataSource = this.connectionFactory.dataSource;
            String[] options = DATA_SOURCE_OPTIONS;
            if (dataSource.getClass().getName().startsWith("com.mchange.v2.c3p0.")) {
                options = C3P0_OPTIONS;
            }
            return (name = (String)this.findBestMethod(dataSource, options)) != null ? name : "unknown";
        }

        private Object findBestMethod(Object receiver, String[] possibleNames) {
            for (String name : possibleNames) {
                try {
                    Method method = receiver.getClass().getMethod(name, new Class[0]);
                    return method.invoke(receiver, new Object[0]);
                }
                catch (Exception e) {
                }
            }
            return null;
        }
    }

    private static class ConnectionTracer
    extends DefaultTracer
    implements DatabaseTracer {
        public ConnectionTracer(Transaction transaction, ClassMethodSignature sig, Object object, MetricNameFormat metricNameFormatter) {
            super(transaction, sig, object, metricNameFormatter);
        }

        protected void doRecordMetrics(StatsEngine statsEngine, TransactionData transactionData) {
            statsEngine.getResponseTimeStats(MetricSpec.DATABASE_GET_CONNECTION).recordResponseTime(this.getExclusiveDuration(), TimeUnit.NANOSECONDS);
        }
    }
}

