/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation.pointcuts.database;

import com.newrelic.agent.Transaction;
import com.newrelic.agent.instrumentation.ClassTransformer;
import com.newrelic.agent.instrumentation.PointCutConfiguration;
import com.newrelic.agent.instrumentation.TracerFactoryPointCut;
import com.newrelic.agent.instrumentation.classmatchers.ClassMatcher;
import com.newrelic.agent.instrumentation.classmatchers.InterfaceMatcher;
import com.newrelic.agent.instrumentation.methodmatchers.ExactMethodMatcher;
import com.newrelic.agent.instrumentation.methodmatchers.InstanceMethodMatcher;
import com.newrelic.agent.instrumentation.methodmatchers.MethodMatcher;
import com.newrelic.agent.instrumentation.methodmatchers.OrMethodMatcher;
import com.newrelic.agent.instrumentation.pointcuts.PointCut;
import com.newrelic.agent.instrumentation.pointcuts.database.CreatePreparedStatementPointCut;
import com.newrelic.agent.instrumentation.pointcuts.database.SqlStatementTracer;
import com.newrelic.agent.service.ServiceManagerFactory;
import com.newrelic.agent.tracers.ClassMethodSignature;
import com.newrelic.agent.tracers.Tracer;
import java.sql.PreparedStatement;

@PointCut
public class GenericPreparedStatementPointCut
extends TracerFactoryPointCut {
    public static final String PREPARED_STATEMENT_INTERFACE = "java/sql/PreparedStatement";
    static final MethodMatcher METHOD_MATCHER = new InstanceMethodMatcher(OrMethodMatcher.getMethodMatcher(new ExactMethodMatcher("executeQuery", "()Ljava/sql/ResultSet;"), new ExactMethodMatcher("executeUpdate", "()I"), new ExactMethodMatcher("execute", "()Z")));

    public GenericPreparedStatementPointCut(ClassTransformer classTransformer) {
        super(new PointCutConfiguration("jdbc_prepared_statement", null, ServiceManagerFactory.getServiceManager().getConfigService().getAgentConfig().isGenericJDBCSupportEnabled()), (ClassMatcher)new InterfaceMatcher(PREPARED_STATEMENT_INTERFACE), METHOD_MATCHER);
        this.setPriority(Integer.MIN_VALUE);
    }

    public Tracer getTracer(Transaction transaction, ClassMethodSignature sig, Object statement, Object[] args) {
        Tracer parent = transaction.getLastTracer();
        if (parent != null && parent instanceof PreparedStatementTracer) {
            return null;
        }
        return new PreparedStatementTracer(transaction, sig, statement, args);
    }

    private class PreparedStatementTracer
    extends SqlStatementTracer {
        public PreparedStatementTracer(Transaction transaction, ClassMethodSignature sig, Object statement, Object[] args) {
            super(transaction, sig, statement, CreatePreparedStatementPointCut.getPreparedStatementSql(transaction, (PreparedStatement)statement));
        }
    }
}

