/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation.pointcuts.database;

import com.newrelic.agent.Agent;
import com.newrelic.agent.Transaction;
import com.newrelic.agent.config.AgentConfig;
import com.newrelic.agent.config.TransactionTracerConfig;
import com.newrelic.agent.database.DefaultDatabaseStatementParser;
import com.newrelic.agent.database.ParsedDatabaseStatement;
import com.newrelic.agent.instrumentation.ClassTransformer;
import com.newrelic.agent.instrumentation.PointCutConfiguration;
import com.newrelic.agent.instrumentation.classmatchers.ExactClassMatcher;
import com.newrelic.agent.instrumentation.classmatchers.OrClassMatcher;
import com.newrelic.agent.instrumentation.pointcuts.PointCut;
import com.newrelic.agent.instrumentation.pointcuts.database.AbstractPreparedStatementPointCut;
import com.newrelic.agent.instrumentation.pointcuts.database.CreatePreparedStatementPointCut;
import com.newrelic.agent.instrumentation.pointcuts.database.DefaultStatementData;
import com.newrelic.agent.instrumentation.pointcuts.database.GenericPreparedStatementPointCut;
import com.newrelic.agent.instrumentation.pointcuts.database.SqlStatementTracer;
import com.newrelic.agent.instrumentation.pointcuts.database.StatementData;
import com.newrelic.agent.service.ServiceManagerFactory;
import com.newrelic.agent.tracers.ClassMethodSignature;
import com.newrelic.agent.tracers.Tracer;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@PointCut
public class MySQLPreparedStatementPointCut
extends AbstractPreparedStatementPointCut {
    private static final String MYSQL_PREPARED_STATEMENT_CLASS_NAME = "com/mysql/jdbc/PreparedStatement";
    private static final String MYSQL_CALLABLE_STATEMENT_CLASS_NAME = "com/mysql/jdbc/CallableStatement";
    private static final Pattern SELECT_PATTERN = Pattern.compile("select", 2);
    private static final String MYSQL_ORIGINAL_SQL_METHOD_KEY = "MYSQL_ORIGINAL_SQL";
    private static final String MYSQL_PREPARED_STATEMENT_AS_SQL_METHOD = "MYSQL_PREPARED_STATEMENT_AS_SQL";
    private final boolean genericJdbcEnabled;
    private final boolean explainsEnabled;
    private final int maxExplains;
    private final DefaultDatabaseStatementParser databaseStatementParser;
    private static boolean tryAsSql = true;

    public MySQLPreparedStatementPointCut(ClassTransformer classTransformer) {
        super(new PointCutConfiguration("jdbc_mysql_prepared_statement", null, MySQLPreparedStatementPointCut.isEnabledByDefault()), OrClassMatcher.getClassMatcher(new ExactClassMatcher(MYSQL_PREPARED_STATEMENT_CLASS_NAME), new ExactClassMatcher(MYSQL_CALLABLE_STATEMENT_CLASS_NAME)), GenericPreparedStatementPointCut.METHOD_MATCHER);
        AgentConfig agentConfig = ServiceManagerFactory.getServiceManager().getConfigService().getAgentConfig();
        this.genericJdbcEnabled = agentConfig.isGenericJDBCSupportEnabled();
        TransactionTracerConfig ttConfig = agentConfig.getTransactionTracerConfig();
        this.explainsEnabled = ttConfig.isEnabled() && ttConfig.isExplainEnabled();
        this.maxExplains = ttConfig.getMaxExplainPlans();
        this.databaseStatementParser = new DefaultDatabaseStatementParser(agentConfig);
    }

    public Tracer getTracer(Transaction transaction, ClassMethodSignature sig, Object statement, Object[] args) {
        Tracer parent = null;
        if (this.genericJdbcEnabled) {
            parent = transaction.getLastTracer();
        }
        PreparedStatement stmt = (PreparedStatement)statement;
        if (this.explainsEnabled && transaction.getExplainPlanCount() <= this.maxExplains) {
            if (parent instanceof SqlStatementTracer) {
                SqlStatementTracer parentStatementTracer = (SqlStatementTracer)parent;
                StatementData stmtData = parentStatementTracer.getStatementData();
                parentStatementTracer.setStatementData(this.createStatementData(transaction, stmtData, stmt));
                return null;
            }
            StatementData stmtData = this.getPreparedStatementSql(sig, args, transaction, stmt);
            return new SqlStatementTracer(transaction, sig, statement, this.createStatementData(transaction, stmtData, stmt));
        }
        if (parent instanceof SqlStatementTracer) {
            return null;
        }
        StatementData stmtData = this.getPreparedStatementSql(sig, args, transaction, stmt);
        return new SqlStatementTracer(transaction, sig, statement, stmtData);
    }

    protected String findSql(Transaction transaction, ClassMethodSignature sig, Object stmt) throws Exception {
        return this.getOriginalSqlStatement(transaction, (PreparedStatement)stmt);
    }

    private StatementData createStatementData(Transaction transaction, StatementData stmtData, PreparedStatement stmt) {
        if (stmtData == null) {
            String sql = MySQLPreparedStatementPointCut.getFullSqlStatement(transaction, stmt);
            return new CreatePreparedStatementPointCut.PreparedStatementData(this.databaseStatementParser, stmt, sql, true);
        }
        return new MySQLStatementData(stmtData, stmt);
    }

    private StatementData getPreparedStatementSql(final ClassMethodSignature sig, final Object[] args, final Transaction transaction, final PreparedStatement stmt) {
        StatementData preparedStatementSql = null;
        CreatePreparedStatementPointCut.getPreparedStatementSql(transaction, stmt);
        if (preparedStatementSql == null) {
            String sql = this.getSql(transaction, sig, stmt);
            DefaultStatementData data = new DefaultStatementData(this.databaseStatementParser, stmt, sql, true){

                protected ResultSetMetaData getResultSetMetaData(Object returnValue) throws SQLException {
                    if ("executeQuery".equals(sig.getMethodName()) && args.length == 1 && args[0] instanceof ResultSet) {
                        return ((ResultSet)args[0]).getMetaData();
                    }
                    return null;
                }

                public String getSqlForExplainPlan() {
                    return MySQLPreparedStatementPointCut.getFullSqlStatement(transaction, stmt);
                }
            };
            CreatePreparedStatementPointCut.getObjectTracker(transaction).put(stmt, data);
            return data;
        }
        return preparedStatementSql;
    }

    protected static boolean isEnabledByDefault() {
        AgentConfig agentConfig = ServiceManagerFactory.getServiceManager().getConfigService().getAgentConfig();
        boolean genericJdbcEnabled = agentConfig.isGenericJDBCSupportEnabled();
        return genericJdbcEnabled || agentConfig.getJDBCSupport().contains("mysql");
    }

    private String getOriginalSqlStatement(Transaction transaction, PreparedStatement stmt) {
        Map<String, Field> fieldCache = transaction.getObjectMap("FIELD_CACHE");
        try {
            Field sqlField = (Field)fieldCache.get(MYSQL_ORIGINAL_SQL_METHOD_KEY);
            if (sqlField == null) {
                Class<?> statementClass = stmt.getClass().getClassLoader().loadClass("com.mysql.jdbc.PreparedStatement");
                if (!statementClass.isInstance(stmt)) {
                    return MySQLPreparedStatementPointCut.getFullSqlStatement(transaction, stmt);
                }
                sqlField = statementClass.getDeclaredField("originalSql");
                sqlField.setAccessible(true);
                fieldCache.put(MYSQL_ORIGINAL_SQL_METHOD_KEY, sqlField);
            }
            return (String)sqlField.get(stmt);
        }
        catch (Exception e) {
            Agent.LOG.log(Level.FINEST, "Error getting original sql for MySql PreparedStatement", e);
            return MySQLPreparedStatementPointCut.getFullSqlStatement(transaction, stmt);
        }
    }

    private static String getFullSqlStatement(Transaction transaction, Statement statement) {
        return MySQLPreparedStatementPointCut.applyBinaryFix(MySQLPreparedStatementPointCut.getFullSqlStatementWithoutBinaryFix(transaction, statement));
    }

    static String applyBinaryFix(String sql) {
        int index = sql.indexOf("_binary");
        if (index > 0) {
            return sql.substring(0, index) + "?";
        }
        return sql;
    }

    private static String getFullSqlStatementWithoutBinaryFix(Transaction transaction, Statement statement) {
        if (!tryAsSql) {
            return MySQLPreparedStatementPointCut.scrapeSqlFromToString(statement.toString());
        }
        try {
            Map<String, Method> methodCache = transaction.getMethodCache();
            Method asSql = methodCache.get(MYSQL_PREPARED_STATEMENT_AS_SQL_METHOD);
            if (asSql == null) {
                Class<?> statementClass = statement.getClass().getClassLoader().loadClass("com.mysql.jdbc.PreparedStatement");
                asSql = statementClass.getDeclaredMethod("asSql", new Class[0]);
                asSql.setAccessible(true);
                methodCache.put(MYSQL_PREPARED_STATEMENT_AS_SQL_METHOD, asSql);
            }
            return (String)asSql.invoke((Object)statement, new Object[0]);
        }
        catch (Exception e) {
            tryAsSql = false;
            Agent.LOG.log(Level.FINEST, "Unable to call MySQLPreparedStatement.asSql", e);
            return MySQLPreparedStatementPointCut.scrapeSqlFromToString(statement.toString());
        }
    }

    static String scrapeSqlFromToString(String sql) {
        int start;
        Matcher matcher = SELECT_PATTERN.matcher(sql);
        if (matcher.find() && (start = matcher.start()) > 0) {
            return sql.substring(start);
        }
        return sql;
    }

    private static class MySQLStatementData
    implements StatementData {
        private final StatementData data;
        private String fullSql;
        private final PreparedStatement statement;

        public MySQLStatementData(StatementData data, PreparedStatement statement) {
            assert (data != null);
            this.data = data;
            this.statement = statement;
        }

        public boolean isExplainSupported() {
            return true;
        }

        public String getSql() {
            return this.data.getSql();
        }

        public String getSqlForExplainPlan() {
            if (this.fullSql == null) {
                this.fullSql = MySQLPreparedStatementPointCut.getFullSqlStatement(Transaction.getTransaction(), this.statement);
            }
            return this.fullSql;
        }

        public ParsedDatabaseStatement getParsedStatement(Object returnValue) {
            return this.data.getParsedStatement(returnValue);
        }

        public Statement getStatement() {
            return this.data.getStatement();
        }
    }
}

