/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation.pointcuts.database;

import com.newrelic.agent.Agent;
import com.newrelic.agent.Transaction;
import com.newrelic.agent.database.DatabaseStatementParser;
import com.newrelic.agent.database.DefaultDatabaseStatementParser;
import com.newrelic.agent.instrumentation.ClassTransformer;
import com.newrelic.agent.instrumentation.TracerFactoryPointCut;
import com.newrelic.agent.instrumentation.classmatchers.ClassMatcher;
import com.newrelic.agent.instrumentation.classmatchers.ExactClassMatcher;
import com.newrelic.agent.instrumentation.pointcuts.PointCut;
import com.newrelic.agent.instrumentation.pointcuts.database.DefaultStatementData;
import com.newrelic.agent.instrumentation.pointcuts.database.SqlStatementTracer;
import com.newrelic.agent.service.ServiceManagerFactory;
import com.newrelic.agent.tracers.ClassMethodSignature;
import com.newrelic.agent.tracers.Tracer;
import java.lang.reflect.Method;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Level;

@PointCut
public class PostgresStatementPointCut
extends TracerFactoryPointCut {
    static final ExactClassMatcher POSTGRESQL_STATEMENT_CLASS_MATCHER = new ExactClassMatcher("org/postgresql/jdbc2/AbstractJdbc2Statement");
    private final DatabaseStatementParser sqlParser = new DefaultDatabaseStatementParser(ServiceManagerFactory.getServiceManager().getConfigService().getAgentConfig());

    public PostgresStatementPointCut(ClassTransformer classTransformer) {
        super(PostgresStatementPointCut.class, (ClassMatcher)POSTGRESQL_STATEMENT_CLASS_MATCHER, PostgresStatementPointCut.createExactMethodMatcher("execute", "(Lorg/postgresql/core/Query;Lorg/postgresql/core/ParameterList;I)V"));
    }

    public Tracer getTracer(Transaction transaction, ClassMethodSignature sig, Object statement, Object[] args) {
        Object query = args[0];
        Object parameters = args[1];
        try {
            Class<?> parametersClass = statement.getClass().getClassLoader().loadClass("org.postgresql.core.ParameterList");
            Class<?> queryClass = statement.getClass().getClassLoader().loadClass("org.postgresql.core.Query");
            Method toStringMethod = queryClass.getMethod("toString", parametersClass);
            String sql = (String)toStringMethod.invoke(query, parameters);
            DefaultStatementData statementData = new DefaultStatementData(this.sqlParser, (Statement)statement, sql, true){

                protected ResultSetMetaData getResultSetMetaData(Object returnValue) throws SQLException {
                    return null;
                }
            };
            return new SqlStatementTracer(transaction, sig, statement, statementData);
        }
        catch (Exception e) {
            Agent.LOG.log(Level.FINE, "Error in postgres statement execute : {0}", e.toString());
            Agent.LOG.log(Level.FINER, "postgres error", e);
            return null;
        }
    }
}

