/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation.pointcuts.database;

import com.newrelic.agent.Transaction;
import com.newrelic.agent.config.AgentConfig;
import com.newrelic.agent.database.DefaultDatabaseStatementParser;
import com.newrelic.agent.instrumentation.ClassTransformer;
import com.newrelic.agent.instrumentation.PointCutConfiguration;
import com.newrelic.agent.instrumentation.classmatchers.ClassMatcher;
import com.newrelic.agent.instrumentation.classmatchers.ExactClassMatcher;
import com.newrelic.agent.instrumentation.pointcuts.PointCut;
import com.newrelic.agent.instrumentation.pointcuts.database.AbstractPreparedStatementPointCut;
import com.newrelic.agent.instrumentation.pointcuts.database.DefaultStatementData;
import com.newrelic.agent.instrumentation.pointcuts.database.GenericPreparedStatementPointCut;
import com.newrelic.agent.instrumentation.pointcuts.database.SqlStatementTracer;
import com.newrelic.agent.service.ServiceManagerFactory;
import com.newrelic.agent.tracers.ClassMethodSignature;
import com.newrelic.agent.tracers.Tracer;
import java.lang.reflect.Field;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;

@PointCut
public class SQLServerPreparedStatementPointCut
extends AbstractPreparedStatementPointCut {
    private static final String SQLSERVER_PREPARED_STATEMENT_MATCH = "com/microsoft/sqlserver/jdbc/SQLServerPreparedStatement";
    private static final String SQLSERVER_PREPARED_STATEMENT = "com.microsoft.sqlserver.jdbc.SQLServerPreparedStatement";
    private static final String SQLSERVER_PREPARED_STATEMENT_SQL_FIELD = "sqlCommand";
    private final DefaultDatabaseStatementParser databaseStatementParser;

    public SQLServerPreparedStatementPointCut(ClassTransformer classTransformer) {
        super(new PointCutConfiguration("jdbc_sqlserver_prepared_statement", null, true), (ClassMatcher)new ExactClassMatcher(SQLSERVER_PREPARED_STATEMENT_MATCH), GenericPreparedStatementPointCut.METHOD_MATCHER);
        AgentConfig agentConfig = ServiceManagerFactory.getServiceManager().getConfigService().getAgentConfig();
        this.databaseStatementParser = new DefaultDatabaseStatementParser(agentConfig);
    }

    public Tracer getTracer(Transaction transaction, ClassMethodSignature sig, Object statement, Object[] args) {
        String sql = this.getSql(transaction, sig, statement);
        DefaultStatementData statementData = new DefaultStatementData(this.databaseStatementParser, (Statement)statement, sql, true){

            protected ResultSetMetaData getResultSetMetaData(Object returnValue) throws SQLException {
                return null;
            }
        };
        return new SqlStatementTracer(transaction, sig, statement, statementData);
    }

    protected String findSql(Transaction transaction, ClassMethodSignature sig, Object statement) throws Exception {
        Class<?> clazz = statement.getClass().getClassLoader().loadClass(SQLSERVER_PREPARED_STATEMENT);
        Field field = clazz.getDeclaredField(SQLSERVER_PREPARED_STATEMENT_SQL_FIELD);
        field.setAccessible(true);
        return (String)field.get(statement);
    }
}

