/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation.pointcuts.database;

import com.newrelic.agent.Agent;
import com.newrelic.agent.Transaction;
import com.newrelic.agent.config.TransactionTracerConfig;
import com.newrelic.agent.instrumentation.ClassTransformer;
import com.newrelic.agent.instrumentation.PointCutConfiguration;
import com.newrelic.agent.instrumentation.TracerFactoryPointCut;
import com.newrelic.agent.instrumentation.classmatchers.ClassMatcher;
import com.newrelic.agent.instrumentation.classmatchers.InterfaceMatcher;
import com.newrelic.agent.instrumentation.pointcuts.PointCut;
import com.newrelic.agent.instrumentation.pointcuts.database.ConnectionFactory;
import com.newrelic.agent.service.ServiceManagerFactory;
import com.newrelic.agent.tracers.ClassMethodSignature;
import com.newrelic.agent.tracers.DatabaseTracer;
import com.newrelic.agent.tracers.MethodExitTracer;
import com.newrelic.agent.tracers.Tracer;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@PointCut
public class SqlDriverPointCut
extends TracerFactoryPointCut {
    public SqlDriverPointCut(ClassTransformer classTransformer) {
        super(new PointCutConfiguration("jdbc_driver"), (ClassMatcher)new InterfaceMatcher("java/sql/Driver"), SqlDriverPointCut.createExactMethodMatcher("connect", "(Ljava/lang/String;Ljava/util/Properties;)Ljava/sql/Connection;"));
    }

    @Override
    public boolean isEnabled() {
        TransactionTracerConfig transactionTracerConfig = ServiceManagerFactory.getServiceManager().getConfigService().getAgentConfig().getTransactionTracerConfig();
        if (transactionTracerConfig.isEnabled() && transactionTracerConfig.isExplainEnabled()) {
            return super.isEnabled();
        }
        return false;
    }

    static final Map<Connection, ConnectionFactory> getAgentConnectionTracker(Transaction transaction) {
        return transaction.getObjectMap("SQLDriverConnection");
    }

    public static final void putConnectionFactory(Transaction transaction, Connection connection, ConnectionFactory factory) {
        if (Agent.isDebugEnabled()) {
            Agent.LOG.finer("Tracking connection: " + connection.getClass().getName());
        }
        if (ServiceManagerFactory.getServiceManager().getTransactionTraceService().isEnabled()) {
            SqlDriverPointCut.getAgentConnectionTracker(transaction).put(connection, factory);
        }
    }

    public static ConnectionFactory getConnectionFactory(Transaction transaction, Connection connection) {
        Map<Connection, ConnectionFactory> connections = SqlDriverPointCut.getAgentConnectionTracker(transaction);
        ConnectionFactory connectionFactory = connections.get(connection);
        if (connectionFactory == null) {
            if (connections.size() == 1) {
                return connections.values().iterator().next();
            }
            if (connections.size() < 100) {
                for (Map.Entry<Connection, ConnectionFactory> entry : connections.entrySet()) {
                    if (!connection.equals(entry.getKey()) && !entry.getKey().equals(connection)) continue;
                    connections.put(connection, entry.getValue());
                    return entry.getValue();
                }
            }
        }
        return connectionFactory;
    }

    @Override
    public Tracer getTracer(Transaction transaction, ClassMethodSignature sig, Object driver, Object[] args) {
        return transaction.isOverTracerSegmentLimit() ? null : new ConnectionTracer(transaction, sig, driver, args);
    }

    private static class DriverConnectionFactory
    implements ConnectionFactory {
        private static final Properties EMPTY_PROPERTIES = new Properties();
        private final Driver driver;
        private final String url;
        private final Properties props;

        public DriverConnectionFactory(Driver driver, String url, Properties props) {
            this.driver = driver;
            this.url = url;
            this.props = props == null || props.isEmpty() ? EMPTY_PROPERTIES : props;
        }

        public Connection getConnection() throws SQLException {
            try {
                return this.driver.connect(this.url, this.props);
            }
            catch (SQLException e) {
                this.logError();
                throw e;
            }
            catch (Exception e) {
                this.logError();
                throw new SQLException(e);
            }
        }

        private void logError() {
            Agent.LOG.log(Level.FINER, "An error occurred getting a database connection. Driver:{0} url:{1}", new Object[]{this.driver, this.url});
        }

        public String getUrl() {
            return this.url;
        }
    }

    private static class ConnectionTracer
    extends MethodExitTracer
    implements DatabaseTracer {
        private ConnectionFactory connectionFactory;

        public ConnectionTracer(Transaction transaction, ClassMethodSignature sig, Object driver, Object[] args) {
            super(sig, transaction);
            this.connectionFactory = new DriverConnectionFactory((Driver)driver, (String)args[0], (Properties)args[1]);
        }

        protected void doFinish(int opcode, Object connection) {
            if (connection != null) {
                SqlDriverPointCut.putConnectionFactory(this.getTransaction(), (Connection)connection, this.connectionFactory);
            }
        }
    }
}

