/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation.pointcuts.frameworks.cxf;

import com.newrelic.agent.Transaction;
import com.newrelic.agent.instrumentation.ClassTransformer;
import com.newrelic.agent.instrumentation.TracerFactoryPointCut;
import com.newrelic.agent.instrumentation.classmatchers.ClassMatcher;
import com.newrelic.agent.instrumentation.classmatchers.ExactClassMatcher;
import com.newrelic.agent.instrumentation.pointcuts.PointCut;
import com.newrelic.agent.tracers.ClassMethodSignature;
import com.newrelic.agent.tracers.DefaultTracer;
import com.newrelic.agent.tracers.Tracer;
import com.newrelic.agent.tracers.metricname.SimpleMetricNameFormat;
import com.newrelic.agent.util.Strings;
import java.lang.reflect.Method;

@PointCut
public class CXFInvokerPointCut
extends TracerFactoryPointCut {
    static final String HTTP_PREFIX = "http://";
    static final String CXF_WEB_TRANSACTION = "WebTransaction/CXF";

    public CXFInvokerPointCut(ClassTransformer classTransformer) {
        super(CXFInvokerPointCut.class, (ClassMatcher)new ExactClassMatcher("org/apache/cxf/service/invoker/AbstractInvoker"), CXFInvokerPointCut.createExactMethodMatcher("performInvocation", "(Lorg/apache/cxf/message/Exchange;Ljava/lang/Object;Ljava/lang/reflect/Method;[Ljava/lang/Object;)Ljava/lang/Object;"));
    }

    public Tracer getTracer(Transaction transaction, ClassMethodSignature sig, Object invoker, Object[] args) {
        Object service = args[1];
        Method method = (Method)args[2];
        String address = (String)transaction.getParameters().remove("cfx_end_point");
        if (address != null) {
            if (address.startsWith(HTTP_PREFIX)) {
                address.substring(HTTP_PREFIX.length());
            }
            StringBuilder path = new StringBuilder(address);
            if (!address.endsWith("/")) {
                path.append('/');
            }
            path.append(method.getName());
            transaction.setNormalizedUri(CXFInvokerPointCut.getCXFMetricName(address, method));
        }
        return new DefaultTracer(transaction, sig, invoker, new SimpleMetricNameFormat(Strings.join('/', "Java", service.getClass().getName(), method.getName())));
    }

    static String getCXFMetricName(String address, Method method) {
        if (address.startsWith(HTTP_PREFIX)) {
            int start = address.indexOf(47, HTTP_PREFIX.length());
            address = start > 0 ? address.substring(start) : address.substring(HTTP_PREFIX.length());
        }
        StringBuilder path = new StringBuilder(CXF_WEB_TRANSACTION);
        if (!address.startsWith("/")) {
            path.append('/');
        }
        path.append(address);
        if (!address.endsWith("/")) {
            path.append('/');
        }
        path.append(method.getName());
        return path.toString();
    }
}

