/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation.pointcuts.frameworks.spring;

import com.newrelic.agent.Transaction;
import com.newrelic.agent.config.AgentConfig;
import com.newrelic.agent.config.Config;
import com.newrelic.agent.instrumentation.ClassTransformer;
import com.newrelic.agent.instrumentation.PointCutConfiguration;
import com.newrelic.agent.instrumentation.TracerFactoryPointCut;
import com.newrelic.agent.instrumentation.classmatchers.ClassMatcher;
import com.newrelic.agent.instrumentation.classmatchers.ExactClassMatcher;
import com.newrelic.agent.instrumentation.pointcuts.PointCut;
import com.newrelic.agent.service.ServiceManagerFactory;
import com.newrelic.agent.tracers.ClassMethodSignature;
import com.newrelic.agent.tracers.DefaultTracer;
import com.newrelic.agent.tracers.Tracer;
import com.newrelic.agent.tracers.metricname.SimpleMetricNameFormat;
import java.lang.reflect.Method;

@PointCut
public class HandlerMethodInvokerPointCut
extends TracerFactoryPointCut {
    private static final String TRANSACTION_NAMING_CONFIG_PARAMETER_NAME = "transaction_naming_scheme";
    private static final String SPRING_FRAMEWORK_CONFIG_PARAMETER_NAME = "spring_framework";
    private static final String CONTROLLER_METHOD_NAMING = "controller_method";
    private static final String VIEW_NAMING = "view";
    private static final String DEFAULT_NAMING_METHOD = "view";
    private final boolean useFullPackageName;
    private final boolean normalizeTransactions;
    private final boolean normalizationDisabled;

    public HandlerMethodInvokerPointCut(ClassTransformer classTransformer) {
        super(new PointCutConfiguration("spring_handler_method_invoker"), (ClassMatcher)new ExactClassMatcher("org/springframework/web/bind/annotation/support/HandlerMethodInvoker"), HandlerMethodInvokerPointCut.createExactMethodMatcher("doInvokeMethod", "(Ljava/lang/reflect/Method;Ljava/lang/Object;[Ljava/lang/Object;)Ljava/lang/Object;"));
        AgentConfig config = ServiceManagerFactory.getServiceManager().getConfigService().getAgentConfig();
        this.useFullPackageName = HandlerMethodInvokerPointCut.getSpringConfiguration(config).getProperty("use_full_package_name", false);
        this.normalizeTransactions = CONTROLLER_METHOD_NAMING.equals(HandlerMethodInvokerPointCut.getSpringConfiguration(config).getProperty(TRANSACTION_NAMING_CONFIG_PARAMETER_NAME, "view"));
        this.normalizationDisabled = !this.normalizeTransactions && !HandlerMethodInvokerPointCut.useViewNameToNormalize(config);
    }

    private static Config getSpringConfiguration(AgentConfig config) {
        return config.getInstrumentationConfig().getConfig(SPRING_FRAMEWORK_CONFIG_PARAMETER_NAME);
    }

    static boolean useViewNameToNormalize(AgentConfig config) {
        return "view".equals(HandlerMethodInvokerPointCut.getSpringConfiguration(config).getProperty(TRANSACTION_NAMING_CONFIG_PARAMETER_NAME, "view"));
    }

    public Tracer getTracer(final Transaction transaction, ClassMethodSignature sig, Object invoker, final Object[] args) {
        if (this.normalizeTransactions) {
            this.setTransactionName(transaction, args);
        }
        return new DefaultTracer(transaction, sig, invoker, new SimpleMetricNameFormat("Spring/Java/" + args[1].getClass().getName() + '/' + ((Method)args[0]).getName())){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void doFinish(Throwable throwable) {
                try {
                    if (!HandlerMethodInvokerPointCut.this.normalizationDisabled) {
                        HandlerMethodInvokerPointCut.this.setTransactionName(transaction, args);
                    }
                    Object var3_2 = null;
                    super.doFinish(throwable);
                }
                catch (Throwable throwable2) {
                    Object var3_3 = null;
                    super.doFinish(throwable);
                    throw throwable2;
                }
            }
        };
    }

    private void setTransactionName(Transaction transaction, Object[] args) {
        if (transaction.getNormalizedUri() == null) {
            Method method = (Method)args[0];
            Object controller = args[1];
            String controllerName = this.useFullPackageName ? controller.getClass().getName() : controller.getClass().getSimpleName();
            transaction.setNormalizedUri("WebTransaction/SpringController/" + controllerName + '/' + method.getName());
        }
    }
}

