/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation.pointcuts.frameworks.spring;

import com.newrelic.agent.Transaction;
import com.newrelic.agent.instrumentation.ClassTransformer;
import com.newrelic.agent.instrumentation.TracerFactoryPointCut;
import com.newrelic.agent.instrumentation.classmatchers.ClassMatcher;
import com.newrelic.agent.instrumentation.classmatchers.ExactClassMatcher;
import com.newrelic.agent.instrumentation.methodmatchers.ExactMethodMatcher;
import com.newrelic.agent.instrumentation.pointcuts.PointCut;
import com.newrelic.agent.instrumentation.pointcuts.frameworks.spring.HandlerMethodInvokerPointCut;
import com.newrelic.agent.instrumentation.pointcuts.frameworks.spring.SpringPointCut;
import com.newrelic.agent.service.ServiceManagerFactory;
import com.newrelic.agent.tracers.ClassMethodSignature;
import com.newrelic.agent.tracers.DefaultTracer;
import com.newrelic.agent.tracers.Tracer;
import com.newrelic.agent.tracers.metricname.ClassMethodMetricNameFormat;
import com.newrelic.agent.tracers.metricname.SimpleMetricNameFormat;

@PointCut
public class SpringDispatcherPointCut
extends TracerFactoryPointCut {
    static final String DISPATCHER_SERVLET_CLASS_NAME = "org/springframework/web/servlet/DispatcherServlet";
    private static final String RENDER_METHOD_NAME = "render";
    private final boolean normalizeTransactions = HandlerMethodInvokerPointCut.useViewNameToNormalize(ServiceManagerFactory.getServiceManager().getConfigService().getAgentConfig());

    public SpringDispatcherPointCut(ClassTransformer classTransformer) {
        super(SpringDispatcherPointCut.class, (ClassMatcher)new ExactClassMatcher(DISPATCHER_SERVLET_CLASS_NAME), SpringDispatcherPointCut.createMethodMatcher(new ExactMethodMatcher(RENDER_METHOD_NAME, "(Lorg/springframework/web/servlet/ModelAndView;Ljavax/servlet/http/HttpServletRequest;Ljavax/servlet/http/HttpServletResponse;)V"), new ExactMethodMatcher("doDispatch", "(Ljavax/servlet/http/HttpServletRequest;Ljavax/servlet/http/HttpServletResponse;)V")));
    }

    public Tracer getTracer(Transaction transaction, ClassMethodSignature sig, Object dispatcher, Object[] args) {
        if (RENDER_METHOD_NAME == sig.getMethodName()) {
            StringBuilder metricName;
            block6: {
                metricName = new StringBuilder("SpringView");
                if (transaction.getNormalizedUri() == null) {
                    try {
                        String viewName = SpringPointCut.getModelAndViewViewName(args[0]);
                        if (viewName == null) break block6;
                        metricName.append(viewName);
                        if (this.normalizeTransactions) {
                            transaction.setNormalizedUri("WebTransaction/SpringView" + viewName);
                        }
                    }
                    catch (Exception e) {
                        metricName.append("/Java/").append(dispatcher.getClass().getName()).append('/').append(sig.getMethodName());
                    }
                } else {
                    metricName.append("/Java/").append(dispatcher.getClass().getName()).append('/').append(sig.getMethodName());
                }
            }
            return new DefaultTracer(transaction, sig, dispatcher, new SimpleMetricNameFormat(metricName.toString()));
        }
        return new DefaultTracer(transaction, sig, dispatcher, new ClassMethodMetricNameFormat(sig, dispatcher));
    }
}

