/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation.pointcuts.frameworks.struts;

import com.newrelic.agent.Agent;
import com.newrelic.agent.Transaction;
import com.newrelic.agent.instrumentation.ClassTransformer;
import com.newrelic.agent.instrumentation.TracerFactoryPointCut;
import com.newrelic.agent.instrumentation.classmatchers.ClassMatcher;
import com.newrelic.agent.instrumentation.classmatchers.ExactClassMatcher;
import com.newrelic.agent.instrumentation.pointcuts.PointCut;
import com.newrelic.agent.tracers.ClassMethodSignature;
import com.newrelic.agent.tracers.MethodExitTracer;
import com.newrelic.agent.tracers.Tracer;
import com.newrelic.agent.util.Invoker;
import java.text.MessageFormat;
import java.util.logging.Level;

@PointCut
public class StrutsActionConfigMatcherPointCut
extends TracerFactoryPointCut {
    public static final String STRUTS_WEB_TRANSACTION = "WebTransaction/Struts";
    public static final String ACTION_CONFIG_MATCHER_CLASS = "org/apache/struts/config/ActionConfigMatcher";

    public StrutsActionConfigMatcherPointCut(ClassTransformer classTransformer) {
        super(StrutsActionConfigMatcherPointCut.class, (ClassMatcher)new ExactClassMatcher(ACTION_CONFIG_MATCHER_CLASS), StrutsActionConfigMatcherPointCut.createExactMethodMatcher("convertActionConfig", "(Ljava/lang/String;Lorg/apache/struts/config/ActionConfig;Ljava/util/Map;)Lorg/apache/struts/config/ActionConfig;"));
    }

    public Tracer getTracer(Transaction transaction, ClassMethodSignature sig, Object matcher, Object[] args) {
        return new StrutsActionConfigMatcherTracer(transaction, sig, matcher, args);
    }

    private static class StrutsActionConfigMatcherTracer
    extends MethodExitTracer {
        public StrutsActionConfigMatcherTracer(Transaction transaction, ClassMethodSignature sig, Object matcher, Object[] args) {
            super(sig);
            try {
                String wildcardPath = (String)Invoker.invoke(args[1], null, "getPath", new Object[0]);
                Agent.LOG.finer("Normalizing path using Struts wildcard");
                transaction.setNormalizedUri(StrutsActionConfigMatcherPointCut.STRUTS_WEB_TRANSACTION + wildcardPath);
            }
            catch (Exception e) {
                String msg = MessageFormat.format("Exception in {0} handling {1}: {2}", StrutsActionConfigMatcherPointCut.class.getSimpleName(), sig, e);
                if (Agent.LOG.isLoggable(Level.FINEST)) {
                    Agent.LOG.log(Level.FINEST, msg, e);
                }
                Agent.LOG.finer(MessageFormat.format(msg, e));
            }
        }

        protected void doFinish(int opcode, Object returnValue) {
        }
    }
}

