/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation.pointcuts.hibernate;

import com.newrelic.agent.Agent;
import com.newrelic.agent.HarvestListener;
import com.newrelic.agent.IRPMService;
import com.newrelic.agent.MetricData;
import com.newrelic.agent.instrumentation.pointcuts.hibernate.StatisticsSampler;
import com.newrelic.agent.service.AbstractService;
import com.newrelic.agent.service.ServiceManagerFactory;
import com.newrelic.agent.stats.StatsEngine;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;

public class HibernateStatisticsService
extends AbstractService
implements HarvestListener {
    public static final String SERVICE_NAME = HibernateStatisticsService.class.getSimpleName();
    private final Collection<StatisticsSampler> samplers = new ArrayList<StatisticsSampler>();

    public HibernateStatisticsService() {
        super(SERVICE_NAME);
    }

    static synchronized HibernateStatisticsService getHibernateStatisticsService(ClassLoader classLoader) {
        HibernateStatisticsService service = (HibernateStatisticsService)ServiceManagerFactory.getServiceManager().getService(SERVICE_NAME);
        if (service == null) {
            service = new HibernateStatisticsService();
            ServiceManagerFactory.getServiceManager().getHarvestService().addHarvestListener(service);
            ServiceManagerFactory.getServiceManager().addService(service);
        }
        return service;
    }

    public synchronized void addStatisticsSampler(StatisticsSampler sampler) {
        this.samplers.add(sampler);
    }

    public boolean isEnabled() {
        return true;
    }

    protected void doStart() {
    }

    protected synchronized void doStop() {
        this.samplers.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void beforeHarvest(IRPMService rpmService) {
        if (!rpmService.isMainApp()) {
            return;
        }
        try {
            ArrayList<List<MetricData>> allMetricData = new ArrayList<List<MetricData>>(this.samplers.size());
            for (StatisticsSampler statisticsSampler : this.samplers) {
                List<MetricData> sample = statisticsSampler.sample();
                allMetricData.add(sample);
            }
            StatsEngine statsEngine = rpmService.getStatsEngine();
            Object object = statsEngine.getHarvestLock();
            synchronized (object) {
                for (List list : allMetricData) {
                    for (MetricData data : list) {
                        statsEngine.getStats(data.getMetricSpec()).merge(data.getStats());
                    }
                }
            }
            for (StatisticsSampler sampler3 : this.samplers) {
                sampler3.clearStats();
            }
        }
        catch (Exception e) {
            Agent.LOG.log(Level.FINE, "Hibernate statistics gathering error : {0}", e.toString());
        }
    }

    public void afterHarvest(IRPMService rpmService) {
    }
}

