/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation.pointcuts.hibernate;

import com.newrelic.agent.Agent;
import com.newrelic.agent.MetricData;
import com.newrelic.agent.instrumentation.pointcuts.hibernate.HibernateStatisticsService;
import com.newrelic.agent.stats.StatsEngineImpl;
import java.lang.reflect.Method;
import java.util.List;
import java.util.logging.Level;
import org.hibernate.SessionFactory;
import org.hibernate.jmx.StatisticsService;
import org.hibernate.stat.EntityStatistics;
import org.hibernate.stat.SecondLevelCacheStatistics;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatisticsSampler {
    private static final String HIBERNATE_STATISTICS = "HibernateStatistics";
    private static final String ENTITIES = "HibernateStatistics/Entity";
    private static final String SECOND_LEVEL_CACHE = "HibernateStatistics/SecondLevelCache";
    private final StatisticsService statisticsService;
    private final StatsEngineImpl statsEngine = new StatsEngineImpl();

    public StatisticsSampler(SessionFactory sessionFactory) {
        this.statisticsService = new StatisticsService();
        this.statisticsService.setSessionFactory(sessionFactory);
        if (!this.statisticsService.isStatisticsEnabled()) {
            this.statisticsService.setStatisticsEnabled(true);
            Agent.LOG.log(Level.INFO, "Enabled Hibernate JMX metrics");
        }
        HibernateStatisticsService statsService = HibernateStatisticsService.getHibernateStatisticsService(this.getClass().getClassLoader());
        statsService.addStatisticsSampler(this);
    }

    public void clearStats() {
        this.statsEngine.clearPendingMetricData();
    }

    public List<MetricData> sample() {
        String[] regionNames;
        String[] entityNames;
        this.statsEngine.getMonotonicallyIncreasingStats("HibernateStatistics/entityLoads").recordDataPoint(this.statisticsService.getEntityLoadCount());
        this.statsEngine.getMonotonicallyIncreasingStats("HibernateStatistics/entityFetches").recordDataPoint(this.statisticsService.getEntityFetchCount());
        this.statsEngine.getMonotonicallyIncreasingStats("HibernateStatistics/entityInserts").recordDataPoint(this.statisticsService.getEntityInsertCount());
        this.statsEngine.getMonotonicallyIncreasingStats("HibernateStatistics/entityUpdates").recordDataPoint(this.statisticsService.getEntityUpdateCount());
        this.statsEngine.getMonotonicallyIncreasingStats("HibernateStatistics/entityDeletes").recordDataPoint(this.statisticsService.getEntityDeleteCount());
        this.statsEngine.getMonotonicallyIncreasingStats("HibernateStatistics/queryCacheHits").recordDataPoint(this.statisticsService.getQueryCacheHitCount());
        this.statsEngine.getMonotonicallyIncreasingStats("HibernateStatistics/queryCacheMisses").recordDataPoint(this.statisticsService.getQueryCacheMissCount());
        this.statsEngine.getMonotonicallyIncreasingStats("HibernateStatistics/queryCachePuts").recordDataPoint(this.statisticsService.getQueryCachePutCount());
        this.statsEngine.getMonotonicallyIncreasingStats("HibernateStatistics/queryExecutions").recordDataPoint(this.statisticsService.getQueryExecutionCount());
        this.statsEngine.getMonotonicallyIncreasingStats("HibernateStatistics/sessionOpens").recordDataPoint(this.statisticsService.getSessionOpenCount());
        this.statsEngine.getMonotonicallyIncreasingStats("HibernateStatistics/sessionCloses").recordDataPoint(this.statisticsService.getSessionCloseCount());
        this.statsEngine.getMonotonicallyIncreasingStats("HibernateStatistics/transactions").recordDataPoint(this.statisticsService.getTransactionCount());
        this.statsEngine.getMonotonicallyIncreasingStats("HibernateStatistics/closeStatements").recordDataPoint(this.statisticsService.getCloseStatementCount());
        this.statsEngine.getMonotonicallyIncreasingStats("HibernateStatistics/flushes").recordDataPoint(this.statisticsService.getFlushCount());
        for (String name : entityNames = this.statisticsService.getEntityNames()) {
            EntityStatistics stats = this.statisticsService.getEntityStatistics(name);
            String rootName = "HibernateStatistics/Entity/" + name + '/';
            Class<?> clazz = stats.getClass();
            try {
                Method m = clazz.getDeclaredMethod("getLoadCount", new Class[0]);
                long res = (Long)m.invoke((Object)stats, new Object[0]);
                this.statsEngine.getMonotonicallyIncreasingStats(rootName + "loads").recordDataPoint(res);
                m = clazz.getDeclaredMethod("getFetchCount", new Class[0]);
                res = (Long)m.invoke((Object)stats, new Object[0]);
                this.statsEngine.getMonotonicallyIncreasingStats(rootName + "fetches").recordDataPoint(res);
                m = clazz.getDeclaredMethod("getInsertCount", new Class[0]);
                res = (Long)m.invoke((Object)stats, new Object[0]);
                this.statsEngine.getMonotonicallyIncreasingStats(rootName + "inserts").recordDataPoint(res);
                m = clazz.getDeclaredMethod("getUpdateCount", new Class[0]);
                res = (Long)m.invoke((Object)stats, new Object[0]);
                this.statsEngine.getMonotonicallyIncreasingStats(rootName + "updates").recordDataPoint(res);
                m = clazz.getDeclaredMethod("getDeleteCount", new Class[0]);
                res = (Long)m.invoke((Object)stats, new Object[0]);
                this.statsEngine.getMonotonicallyIncreasingStats(rootName + "deletes").recordDataPoint(res);
            }
            catch (Exception e) {
                Agent.LOG.log(Level.FINE, "Error in Hibernate StatisticsSampler: {0}", e.toString());
                Agent.LOG.log(Level.FINER, "Hibernate error", e);
            }
        }
        for (String name : regionNames = this.statisticsService.getSecondLevelCacheRegionNames()) {
            SecondLevelCacheStatistics cacheStatistics = this.statisticsService.getSecondLevelCacheStatistics(name);
            String rootName = "HibernateStatistics/SecondLevelCache/" + name + '/';
            this.statsEngine.getMonotonicallyIncreasingStats(rootName + "elementsInMemory").recordDataPoint(cacheStatistics.getElementCountInMemory());
            this.statsEngine.getMonotonicallyIncreasingStats(rootName + "elementsOnDisk").recordDataPoint(cacheStatistics.getElementCountOnDisk());
            this.statsEngine.getMonotonicallyIncreasingStats(rootName + "hits").recordDataPoint(cacheStatistics.getHitCount());
            this.statsEngine.getMonotonicallyIncreasingStats(rootName + "misses").recordDataPoint(cacheStatistics.getMissCount());
            this.statsEngine.getMonotonicallyIncreasingStats(rootName + "puts").recordDataPoint(cacheStatistics.getPutCount());
        }
        List<MetricData> md = this.statsEngine.harvest();
        return md;
    }
}

