/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation.pointcuts.net;

import com.newrelic.agent.Agent;
import com.newrelic.agent.Transaction;
import com.newrelic.agent.instrumentation.ClassTransformer;
import com.newrelic.agent.instrumentation.PointCut;
import com.newrelic.agent.instrumentation.PointCutConfiguration;
import com.newrelic.agent.instrumentation.TracerFactoryPointCut;
import com.newrelic.agent.instrumentation.classmatchers.ClassMatcher;
import com.newrelic.agent.instrumentation.classmatchers.ExactClassMatcher;
import com.newrelic.agent.tracers.ClassMethodSignature;
import com.newrelic.agent.tracers.ExternalComponentTracer;
import com.newrelic.agent.tracers.IOTracer;
import com.newrelic.agent.tracers.Tracer;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Map;
import java.util.logging.Level;

@com.newrelic.agent.instrumentation.pointcuts.PointCut
public class HttpInputStreamPointCut
extends TracerFactoryPointCut {
    public static final String HTTP_INPUT_STREAM_CLASS_NAME = "sun/net/www/protocol/http/HttpURLConnection$HttpInputStream";
    private static final String OBJECT_MAP_KEY = "httpInputStreams";

    public HttpInputStreamPointCut(ClassTransformer classTransformer) {
        super(new PointCutConfiguration("http_input_stream", null, false), (ClassMatcher)new ExactClassMatcher(HTTP_INPUT_STREAM_CLASS_NAME), HttpInputStreamPointCut.createExactMethodMatcher("read", "([BII)I"));
        classTransformer.getClassNameFilter().addIncludeRegex("(^sun/net/www/protocol/http/HttpURLConnection\\$HttpInputStream)");
    }

    public Tracer getTracer(Transaction transaction, ClassMethodSignature sig, Object inputStream, Object[] args) {
        String operation;
        String host;
        Map<Object, URL> streamToUrl = transaction.getObjectMap(OBJECT_MAP_KEY);
        URL url = (URL)streamToUrl.get(inputStream);
        if (url == null) {
            try {
                Method getUrlMethod = HttpURLConnection.class.getMethod("getURL", new Class[0]);
                Field this$0 = inputStream.getClass().getDeclaredField("this$0");
                this$0.setAccessible(true);
                HttpURLConnection connection = (HttpURLConnection)this$0.get(inputStream);
                url = (URL)getUrlMethod.invoke((Object)connection, new Object[0]);
                streamToUrl.put(inputStream, url);
            }
            catch (Throwable t) {
                Agent.LOG.log(Level.FINER, "Error getting url from http input stream", t);
            }
        }
        if (url != null) {
            host = url.getHost();
            operation = url.getPath();
        } else {
            operation = "unknown";
            host = "unknown";
        }
        return new HttpInputStreamTracer(this, transaction, sig, inputStream, host, "HttpInputStream", new String[]{operation});
    }

    private static final class HttpInputStreamTracer
    extends ExternalComponentTracer
    implements IOTracer {
        private HttpInputStreamTracer(PointCut pc, Transaction transaction, ClassMethodSignature sig, Object object, String host, String library, String[] operations) {
            super(transaction, sig, object, host, library, operations);
        }
    }
}

